/*
 * Decompiled with CFR 0.152.
 */
package com.sharethis.textrank;

import com.sharethis.textrank.Graph;
import com.sharethis.textrank.KeyWord;
import com.sharethis.textrank.LanguageModel;
import com.sharethis.textrank.Node;

public class Sentence {
    public String text = null;
    public String[] token_list = null;
    public Node[] node_list = null;
    final String[] tag_list;

    public Sentence(String text, String[] token_list, String[] tag_list) {
        this.text = text;
        this.token_list = token_list;
        this.tag_list = tag_list;
    }

    public void mapTokens(LanguageModel lang, Graph graph) {
        Node last_node = null;
        this.node_list = new Node[this.token_list.length];
        assert (this.token_list.length == this.tag_list.length);
        for (int i = 0; i < this.token_list.length; ++i) {
            String pos = this.tag_list[i];
            if (!lang.isRelevant(pos)) continue;
            String key = lang.getNodeKey(this.token_list[i], pos);
            KeyWord value = new KeyWord(this.token_list[i], pos);
            Node n = Node.buildNode(graph, key, value);
            if (last_node != null) {
                n.connect(last_node);
            }
            last_node = n;
            this.node_list[i] = n;
        }
    }
}

