/*
 * Decompiled with CFR 0.152.
 */
package com.sharethis.textrank;

import com.google.common.collect.ComparisonChain;
import com.sharethis.textrank.Graph;
import com.sharethis.textrank.KeyWord;
import com.sharethis.textrank.NodeValue;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.math3.util.Precision;

public class Node
implements Comparable<Node> {
    public Set<Node> edges = new HashSet<Node>();
    public double rank = 1.0;
    public String key = null;
    public boolean marked = false;
    public NodeValue value = null;

    private Node(String key, NodeValue value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int compareTo(Node that) {
        return ComparisonChain.start().compare(this.rank, that.rank).compare((Comparable)((Object)this.value.text), (Comparable)((Object)that.value.text)).result();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return this.rank == other.rank && Objects.equals(this.value.text, other.value.text);
    }

    public int hashCode() {
        return Objects.hash(this.rank, this.value.text);
    }

    public void connect(Node that) {
        this.edges.add(that);
        that.edges.add(this);
    }

    public void disconnect(Node that) {
        this.edges.remove(that);
        that.edges.remove(this);
    }

    public String getId() {
        return Integer.toString(this.hashCode(), 16);
    }

    public static Node buildNode(Graph graph, String key, NodeValue value) {
        Node n = (Node)graph.get(key);
        if (n == null) {
            n = new Node(key, value);
            graph.put(key, n);
        }
        return n;
    }

    public double maxNeighbor(double min, double coeff) {
        double adjusted_rank = 0.0;
        if (this.edges.size() > 1) {
            double max_rank = 0.0;
            if (max_rank > 0.0) {
                adjusted_rank = (max_rank - min) / coeff;
            }
        } else {
            for (Node n : this.edges) {
                if (!(n.value instanceof KeyWord)) continue;
                adjusted_rank = n.maxNeighbor(min, coeff);
            }
        }
        return adjusted_rank;
    }

    public void serializeGraph(Set<String> entries) {
        StringBuilder sb = new StringBuilder();
        this.marked = true;
        sb.append("node").append('\t');
        sb.append(this.getId()).append('\t');
        sb.append(this.value.getDescription()).append('\t');
        sb.append(Precision.round((double)this.rank, (int)3));
        entries.add(sb.toString());
        for (Node n : this.edges) {
            sb = new StringBuilder();
            sb.append("edge").append('\t');
            sb.append(this.getId()).append('\t');
            sb.append(n.getId());
            entries.add(sb.toString());
            if (n.marked) continue;
            n.serializeGraph(entries);
        }
    }
}

