/*
 * Decompiled with CFR 0.152.
 */
package com.sharethis.textrank;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.sharethis.textrank.Context;
import com.sharethis.textrank.Graph;
import com.sharethis.textrank.KeyWord;
import com.sharethis.textrank.LanguageModel;
import com.sharethis.textrank.Node;
import com.sharethis.textrank.NodeValue;
import com.sharethis.textrank.Sentence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NGram
extends NodeValue
implements Comparable<NGram> {
    public Set<Node> nodes = new HashSet<Node>();
    public Set<Context> contexts = new HashSet<Context>();
    public int length = 0;

    private NGram(String text, Set<Node> nodes, Context context) {
        this.text = text;
        this.nodes = nodes;
        this.length = nodes.size();
        this.contexts.add(context);
    }

    public int getCount() {
        return this.contexts.size();
    }

    @Override
    public String getDescription() {
        return "NGRAM\t" + this.getCollocation();
    }

    public String renderContexts() {
        StringBuilder sb = new StringBuilder();
        for (Context c : this.contexts) {
            sb.append("\n  ").append(c.start).append(": ").append(c.s.text);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(NGram that) {
        return ComparisonChain.start().compare(this.length, that.length).compare(this.getCount(), that.getCount()).compare((Comparable)((Object)this.text), (Comparable)((Object)that.text)).result();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NGram)) {
            return false;
        }
        NGram other = (NGram)obj;
        return this.length == other.length && this.getCount() == other.getCount() && Objects.equal((Object)this.text, (Object)other.text);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.length, this.getCount(), this.text});
    }

    public static NGram buildNGram(Graph ngrams, Sentence s, List<Integer> token_span, double max_rank) {
        HashSet<Node> nodes = new HashSet<Node>();
        StringBuilder sb_key = new StringBuilder("NGram");
        StringBuilder sb_text = new StringBuilder();
        for (int i : token_span) {
            if ("".equals(s.token_list[i])) continue;
            nodes.add(s.node_list[i]);
            sb_key.append(s.node_list[i].key);
            sb_text.append(s.token_list[i]).append(' ');
        }
        Context context = new Context(s, token_span.get(0));
        String gram_key = sb_key.toString();
        Node n = (Node)ngrams.get(gram_key);
        NGram gram = null;
        if (n == null) {
            gram = new NGram(sb_text.toString().trim(), nodes, context);
            if (!"".equals(gram.text.trim())) {
                n = Node.buildNode(ngrams, gram_key, gram);
                n.rank = max_rank;
                ngrams.put(gram_key, n);
            }
        } else {
            gram = (NGram)n.value;
            gram.contexts.add(context);
        }
        return gram;
    }

    public static Graph collectNGrams(LanguageModel lang, List<Sentence> s_list, double rank_threshold) {
        Graph ngrams = new Graph();
        ArrayList<Integer> token_span = new ArrayList<Integer>();
        for (Sentence s : s_list) {
            boolean span_marked = false;
            double max_rank = 0.0;
            token_span.clear();
            for (int i = 0; i < s.node_list.length; ++i) {
                if (s.node_list[i] == null) {
                    if (span_marked && !token_span.isEmpty() && (token_span.size() > 1 || max_rank >= rank_threshold && lang.isNoun(((KeyWord)s.node_list[((Integer)token_span.get((int)0)).intValue()].value).pos))) {
                        NGram.buildNGram(ngrams, s, token_span, max_rank);
                    }
                    token_span.clear();
                    span_marked = false;
                    max_rank = 0.0;
                    continue;
                }
                token_span.add(i);
                span_marked = span_marked || s.node_list[i].marked;
                max_rank = Math.max(max_rank, s.node_list[i].rank);
            }
        }
        return ngrams;
    }

    public static int calcStats(Graph subgraph) {
        int ngram_max_count = 2;
        subgraph.dist_stats.clear();
        for (Node n : subgraph.values()) {
            NGram gram = (NGram)n.value;
            subgraph.dist_stats.addValue(n.rank);
            ngram_max_count = Math.max(gram.getCount(), ngram_max_count);
        }
        return ngram_max_count;
    }
}

