/*
 * Decompiled with CFR 0.152.
 */
package com.sharethis.textrank;

import com.sharethis.textrank.NodeValue;
import java.util.Objects;
import org.apache.commons.math3.util.Precision;

public class MetricVector
implements Comparable<MetricVector> {
    public double metric = 0.0;
    public NodeValue value = null;
    public double link_rank = 0.0;
    public double count_rank = 0.0;
    public double synset_rank = 0.0;

    public MetricVector(NodeValue value, double link_rank, double count_rank, double synset_rank) {
        this.value = value;
        this.metric = Math.sqrt((1.0 * link_rank * link_rank + 0.5 * count_rank * count_rank + 1.5 * synset_rank * synset_rank) / 3.0);
        this.link_rank = Precision.round((double)link_rank, (int)2);
        this.count_rank = Precision.round((double)count_rank, (int)2);
        this.synset_rank = Precision.round((double)synset_rank, (int)2);
    }

    @Override
    public int compareTo(MetricVector that) {
        if (this.metric > that.metric) {
            return -1;
        }
        if (this.metric < that.metric) {
            return 1;
        }
        return this.value.text.compareTo(that.value.text);
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append(Precision.round((double)this.metric, (int)1));
        sb.append(' ');
        sb.append(this.link_rank);
        sb.append(' ');
        sb.append(this.count_rank);
        sb.append(' ');
        sb.append(this.synset_rank);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetricVector)) {
            return false;
        }
        MetricVector other = (MetricVector)obj;
        return this.metric == other.metric && Objects.equals(this.value.text, other.value.text);
    }

    public int hashCode() {
        return Objects.hash(this.metric, this.value.text);
    }
}

