/*
 * Decompiled with CFR 0.152.
 */
package com.sharethis.textrank;

import com.sharethis.textrank.CoreNlpLanguageModel;
import com.sharethis.textrank.Sentence;

public abstract class LanguageModel {
    public static final int TOKEN_LENGTH_LIMIT = 50;

    public static LanguageModel buildLanguage(String lang_code) {
        LanguageModel lang = null;
        if ("en".equals(lang_code)) {
            lang = CoreNlpLanguageModel.englishModel();
        } else if ("de".equals(lang_code)) {
            lang = CoreNlpLanguageModel.germanModel();
        }
        return lang;
    }

    public abstract String[] splitParagraph(String var1);

    public abstract Sentence parseSentence(String var1);

    public abstract String getNodeKey(String var1, String var2);

    public boolean isRelevant(String pos) {
        return this.isNoun(pos) || this.isAdjective(pos);
    }

    public abstract boolean isNoun(String var1);

    public abstract boolean isAdjective(String var1);

    public abstract String stemToken(String var1);

    public String scrubToken(String token_text) {
        String scrubbed = token_text;
        if (scrubbed.length() > 50) {
            scrubbed = scrubbed.substring(0, 50);
        }
        return scrubbed;
    }
}

