/*
 * Decompiled with CFR 0.152.
 */
package com.sharethis.textrank;

import com.sharethis.textrank.Node;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class Graph
extends TreeMap<String, Node> {
    public static final double INCLUSIVE_COEFF = 0.25;
    public static final double KEYWORD_REDUCTION_FACTOR = 0.8;
    public static final double TEXTRANK_DAMPING_FACTOR = 0.85;
    public static final double STANDARD_ERROR_THRESHOLD = 0.005;
    private static final long serialVersionUID = 1L;
    public SummaryStatistics dist_stats = new SummaryStatistics();
    protected Node[] node_list = null;

    public void runTextRank() {
        int max_iterations = this.size();
        this.node_list = new Node[this.size()];
        int j = 0;
        for (Node n1 : this.values()) {
            this.node_list[j++] = n1;
        }
        this.iterateGraph(max_iterations);
    }

    protected void iterateGraph(int max_iterations) {
        double[] rank_list = new double[this.node_list.length];
        for (int k = 0; k < max_iterations; ++k) {
            this.dist_stats.clear();
            for (int i = 0; i < this.node_list.length; ++i) {
                Node n1 = this.node_list[i];
                double rank = 0.0;
                for (Node n2 : n1.edges) {
                    rank += n2.rank / (double)n2.edges.size();
                }
                rank *= 0.85;
                rank_list[i] = rank += 0.15000000000000002;
                this.dist_stats.addValue(Math.abs(n1.rank - rank));
            }
            double standard_error = this.dist_stats.getStandardDeviation() / Math.sqrt(this.dist_stats.getN());
            for (int i = 0; i < this.node_list.length; ++i) {
                this.node_list[i].rank = rank_list[i];
            }
            if (standard_error < 0.005) break;
        }
    }

    public void sortResults(long max_results) {
        Arrays.sort(this.node_list, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                if (n1.rank > n2.rank) {
                    return -1;
                }
                if (n1.rank < n2.rank) {
                    return 1;
                }
                return 0;
            }
        });
        this.dist_stats.clear();
        for (int i = 0; i < this.node_list.length; ++i) {
            Node n1 = this.node_list[i];
            if ((long)i > max_results) continue;
            n1.marked = true;
            this.dist_stats.addValue(n1.rank);
        }
    }

    public double getRankThreshold() {
        return this.dist_stats.getMean() + this.dist_stats.getStandardDeviation() * 0.25;
    }
}

