/*
 * Decompiled with CFR 0.152.
 */
package com.sharethis.textrank;

import com.sharethis.textrank.LanguageModel;
import com.sharethis.textrank.Sentence;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import java.util.ArrayList;
import java.util.List;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.GermanStemmer;

public class CoreNlpLanguageModel
extends LanguageModel {
    private static final String GERMAN_TAGGER_MODEL = "models/german-fast.tagger";
    private static final String ENGLISH_TAGGER_MODEL = "models/english-left3words-distsim.tagger";
    private final WordsToSentencesAnnotator splitter;
    private final TokenizerAnnotator tokenizer;
    private final POSTaggerAnnotator tagger;
    private final SnowballProgram stemmer;

    public CoreNlpLanguageModel(WordsToSentencesAnnotator splitter, TokenizerAnnotator tokenizer, POSTaggerAnnotator tagger, SnowballProgram stemmer) {
        this.splitter = splitter;
        this.tokenizer = tokenizer;
        this.tagger = tagger;
        this.stemmer = stemmer;
    }

    public static LanguageModel englishModel() {
        return new CoreNlpLanguageModel(new WordsToSentencesAnnotator(false), new TokenizerAnnotator(false), new POSTaggerAnnotator(ENGLISH_TAGGER_MODEL, true), (SnowballProgram)new EnglishStemmer());
    }

    public static LanguageModel germanModel() {
        return new CoreNlpLanguageModel(new WordsToSentencesAnnotator(false), new TokenizerAnnotator(false), new POSTaggerAnnotator(GERMAN_TAGGER_MODEL, false), (SnowballProgram)new GermanStemmer());
    }

    @Override
    public String[] splitParagraph(String text) {
        Annotation document = new Annotation(text);
        this.tokenizer.annotate(document);
        this.splitter.annotate(document);
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        return (String[])sentences.stream().map(Object::toString).filter(s -> s != null).toArray(String[]::new);
    }

    String[] tokenizeSentence(String text) {
        Annotation document = new Annotation(text);
        this.tokenizer.annotate(document);
        ArrayList<Object> tokenList = new ArrayList<Object>();
        for (CoreLabel token : (List)document.get(CoreAnnotations.TokensAnnotation.class)) {
            tokenList.add(token.get(CoreAnnotations.TextAnnotation.class));
        }
        return tokenList.toArray(new String[1]);
    }

    @Override
    public Sentence parseSentence(String text) {
        Annotation document = new Annotation(text);
        this.tokenizer.annotate(document);
        this.splitter.annotate(document);
        this.tagger.annotate(document);
        ArrayList<Object> tokens = new ArrayList<Object>();
        ArrayList<Object> tags = new ArrayList<Object>();
        for (CoreLabel token : (List)document.get(CoreAnnotations.TokensAnnotation.class)) {
            tokens.add(token.get(CoreAnnotations.TextAnnotation.class));
            tags.add(token.get(CoreAnnotations.PartOfSpeechAnnotation.class));
        }
        return new Sentence(text, tokens.toArray(new String[tokens.size()]), tags.toArray(new String[tags.size()]));
    }

    @Override
    public String getNodeKey(String text, String pos) {
        return pos.substring(0, 2) + this.stemToken(this.scrubToken(text)).toLowerCase();
    }

    @Override
    public boolean isNoun(String pos) {
        return pos.startsWith("NN");
    }

    @Override
    public boolean isAdjective(String pos) {
        return pos.startsWith("JJ");
    }

    @Override
    public String stemToken(String token) {
        this.stemmer.setCurrent(token);
        this.stemmer.stem();
        return this.stemmer.getCurrent();
    }
}

