/*
 * Decompiled with CFR 0.152.
 */
package de.kune.sessionxs.matcher;

import de.kune.sessionxs.matcher.AbstractSessionMatcher;
import de.kune.sessionxs.matcher.SessionMatcher;
import de.kune.sessionxs.matcher.context.SessionMatcherContext;
import de.kune.sessionxs.matcher.context.StringValueContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHeaderMatcher
extends AbstractSessionMatcher
implements SessionMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHeaderMatcher.class);

    @Override
    public SessionMatcherContext init(HttpServletRequest request) {
        return new StringValueContext(request.getHeader(this.getHeaderKey()));
    }

    @Override
    public boolean matches(SessionMatcherContext context, HttpServletRequest request) {
        if (context instanceof StringValueContext) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Context value: [" + ((StringValueContext)context).getValue() + "], request value: [" + request.getHeader(this.getHeaderKey()) + "]");
            }
            return ((StringValueContext)context).getValue().equals(request.getHeader(this.getHeaderKey()));
        }
        throw new IllegalArgumentException("Context must be of class [" + StringValueContext.class.getName() + "].");
    }

    protected abstract String getHeaderKey();
}

