/*
 * Decompiled with CFR 0.152.
 */
package de.kune.sessionxs;

import de.kune.sessionxs.failurehandler.InvalidatingSessionMatchingFailureHandler;
import de.kune.sessionxs.failurehandler.SessionMatchingFailureHandler;
import de.kune.sessionxs.matcher.ClientIPAddressMatcher;
import de.kune.sessionxs.matcher.SessionMatcher;
import de.kune.sessionxs.matcher.UserAgentHeaderMatcher;
import de.kune.sessionxs.matcher.context.SessionMatcherContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionMatcherFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionMatcherFilter.class);
    private String sessionIdentifierMapKey = this.getClass().getName() + ".sessionIdentifierMap";
    private List<SessionMatcher> sessionMatchers = new LinkedList<SessionMatcher>();
    private SessionMatchingFailureHandler sessionMatchingFailureHandler;

    public void init(FilterConfig filterConfig) throws ServletException {
        String sessionMatchersListString = filterConfig.getInitParameter("session-matchers");
        if (sessionMatchersListString == null) {
            this.sessionMatchers.add(new ClientIPAddressMatcher());
            this.sessionMatchers.add(new UserAgentHeaderMatcher());
        } else {
            try {
                this.initSessionMatchers(sessionMatchersListString);
            }
            catch (Exception e) {
                throw new ServletException("Could not initialize session matchers [" + sessionMatchersListString + "].", (Throwable)e);
            }
        }
        String failureHandlerString = filterConfig.getInitParameter("failure-handler");
        if (failureHandlerString == null) {
            this.sessionMatchingFailureHandler = new InvalidatingSessionMatchingFailureHandler();
        } else {
            try {
                this.initFailureHandler(failureHandlerString);
            }
            catch (Exception e) {
                throw new ServletException("Could not initialize failure handler [" + failureHandlerString + "].", (Throwable)e);
            }
        }
    }

    private void initFailureHandler(String failureHandlerString) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.sessionMatchingFailureHandler = (SessionMatchingFailureHandler)Class.forName(failureHandlerString.trim()).newInstance();
    }

    private void initSessionMatchers(String sessionMatchersListString) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        for (String sessionMatcherString : sessionMatchersListString.split("[,\\s]")) {
            this.sessionMatchers.add((SessionMatcher)Class.forName(sessionMatcherString.trim()).newInstance());
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && (session = ((HttpServletRequest)request).getSession(false)) != null) {
            HashMap<String, SessionMatcherContext> sessionIdentifierMap = (HashMap<String, SessionMatcherContext>)session.getAttribute(this.sessionIdentifierMapKey);
            if (sessionIdentifierMap == null) {
                sessionIdentifierMap = new HashMap<String, SessionMatcherContext>();
                this.initSessionMatchers((HttpServletRequest)request, sessionIdentifierMap);
                session.setAttribute(this.sessionIdentifierMapKey, sessionIdentifierMap);
            } else {
                for (SessionMatcher sessionMatcher : this.sessionMatchers) {
                    if (sessionMatcher.matches((SessionMatcherContext)sessionIdentifierMap.get(sessionMatcher.getClass().getName()), (HttpServletRequest)request)) continue;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Session mismatch reported by [" + sessionMatcher + "], invoking handler [" + this.sessionMatchingFailureHandler + "].");
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Session matcher context is [" + sessionIdentifierMap.get(sessionMatcher.getClass().getName()) + "].");
                        LOGGER.debug("Request was [" + request + "].");
                    }
                    this.sessionMatchingFailureHandler.handleSessionMatchingFailure(chain, (HttpServletRequest)request, (HttpServletResponse)response);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    private void initSessionMatchers(HttpServletRequest request, Map<String, SessionMatcherContext> sessionIdentifierMap) {
        for (SessionMatcher sessionMatcher : this.sessionMatchers) {
            sessionIdentifierMap.put(sessionMatcher.getClass().getName(), sessionMatcher.init(request));
        }
    }

    public void destroy() {
        this.sessionMatchers.clear();
        this.sessionMatchers = null;
        this.sessionMatchingFailureHandler = null;
    }
}

