/**
 * This software is licensed under the MIT license. 
 */
package de.kune.sessionxs.matcher.context;


/**
 * This class provides a simple string value context.
 * 
 * @author Alexander Kune
 * 
 */
public class StringValueContext implements SessionMatcherContext {

	private static final long serialVersionUID = -5482607661064855612L;

	private String value;

	public StringValueContext(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}

	@Override
	public String toString() {
		return super.toString() + "/" + value;
	}
	
}
