/**
 * This software is licensed under the MIT license. 
 */
package de.kune.sessionxs.matcher;


/**
 * Provides user agent header-based matching. This matcher makes sure that all
 * requests in a session originate from the same browser type (that is contain
 * the same User-Agent header).
 * 
 * @author Alexander Kune
 * 
 */
public class UserAgentHeaderMatcher extends AbstractHeaderMatcher implements
		SessionMatcher {

	private static final String HEADER_KEY = "User-Agent";

	@Override
	protected String getHeaderKey() {
		return HEADER_KEY;
	}

}
