/**
 * This software is licensed under the MIT license. 
 */
package de.kune.sessionxs.matcher;

import javax.servlet.http.HttpServletRequest;

import de.kune.sessionxs.matcher.context.SessionMatcherContext;

/**
 * The abstract session matcher is the preferred super class for session matcher
 * implementations. Its purpose is to provide a stable inheritance structure
 * even if the interface {@link SessionMatcher} should change in future
 * releases.
 * 
 * @author Alexander Kune
 * 
 */
public abstract class AbstractSessionMatcher implements SessionMatcher {

	@Override
	public abstract SessionMatcherContext init(HttpServletRequest request);

	@Override
	public abstract boolean matches(SessionMatcherContext context,
			HttpServletRequest request);

}
