/**
 * This software is licensed under the MIT license. 
 */
package de.kune.sessionxs.failurehandler;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import de.kune.sessionxs.SessionMatcherFilter;
import de.kune.sessionxs.matcher.SessionMatcher;

/**
 * Handles session matching failures. A session matching failure handler will be
 * called by {@link SessionMatcherFilter} whenever a {@link SessionMatcher}
 * determines a mismatch between its context and the request.
 * 
 * @author Alexander Kune
 * 
 */
public interface SessionMatchingFailureHandler {

	/**
	 * Handle a session matching failure.
	 * 
	 * @param chain
	 *            the filter chain
	 * @param request
	 *            the request
	 * @param response
	 *            the response
	 * @throws IOException
	 * @throws ServletException
	 */
	void handleSessionMatchingFailure(FilterChain chain,
			HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException;

}
