/**
 * This software is licensed under the MIT license. 
 */
package de.kune.sessionxs.failurehandler;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * A session matching failure handler that invalidates the current session. 
 * @author Alexander Kune
 *
 */
public class InvalidatingSessionMatchingFailureHandler implements
		SessionMatchingFailureHandler {

	@Override
	public void handleSessionMatchingFailure(FilterChain chain,
			HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		request.getSession().invalidate();
		chain.doFilter(request, response);
	}

}
