/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.docker;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.bazhenov.docker.VolumeDef;

public final class ContainerDefinition {
    private final String image;
    private final List<String> command;
    private Map<Integer, Integer> publishedPorts = new HashMap<Integer, Integer>();
    private Map<String, String> environment = new HashMap<String, String>();
    private List<String> customOptions = new LinkedList<String>();
    private boolean removeAfterCompletion = true;
    private boolean waitForAllExposedPortsToBeOpen = true;
    private String workingDirectory;
    private Collection<VolumeDef> volumes = new ArrayList<VolumeDef>();

    public ContainerDefinition(String image, String ... command) {
        this.image = Objects.requireNonNull(image);
        this.command = Objects.requireNonNull(Arrays.asList(command));
    }

    public String getImage() {
        return this.image;
    }

    public Map<Integer, Integer> getPublishedPorts() {
        return this.publishedPorts;
    }

    public void addPublishedPort(int port) {
        this.addPublishedPort(port, 0);
    }

    public void addPublishedPort(int atContainer, int atHost) {
        this.publishedPorts.put(atContainer, atHost);
    }

    public List<String> getCustomOptions() {
        return this.customOptions;
    }

    public void addCustomOption(String option) {
        this.customOptions.add(option);
    }

    public boolean isWaitForAllExposedPortsToBeOpen() {
        return this.waitForAllExposedPortsToBeOpen;
    }

    public void setWaitForAllExposedPortsToBeOpen(boolean waitForAllExposedPortsToBeOpen) {
        this.waitForAllExposedPortsToBeOpen = waitForAllExposedPortsToBeOpen;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void addEnvironment(String var, String value) {
        this.environment.put(var, value);
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setRemoveAfterCompletion(boolean removeAfterCompletion) {
        this.removeAfterCompletion = removeAfterCompletion;
    }

    public boolean isRemoveAfterCompletion() {
        return this.removeAfterCompletion;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void addVolume(String mountPoint) {
        this.addVolume(mountPoint, null);
    }

    public void addVolume(String mountPoint, String locationAtHost) {
        File location = locationAtHost == null ? null : new File(locationAtHost);
        this.addVolume(new VolumeDef(mountPoint, location));
    }

    public void addVolume(VolumeDef volume) {
        Objects.requireNonNull(volume);
        this.volumes.add(volume);
    }

    public Collection<VolumeDef> getVolumes() {
        return this.volumes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerDefinition that = (ContainerDefinition)o;
        return this.removeAfterCompletion == that.removeAfterCompletion && this.waitForAllExposedPortsToBeOpen == that.waitForAllExposedPortsToBeOpen && Objects.equals(this.image, that.image) && Objects.equals(this.command, that.command) && Objects.equals(this.publishedPorts, that.publishedPorts) && Objects.equals(this.environment, that.environment) && Objects.equals(this.workingDirectory, that.workingDirectory) && Objects.equals(this.volumes, that.volumes) && Objects.equals(this.customOptions, that.customOptions);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.command, this.publishedPorts, this.environment, this.removeAfterCompletion, this.waitForAllExposedPortsToBeOpen, this.workingDirectory, this.volumes, this.customOptions);
    }
}

