/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.client;

import de.kosmos_lab.web.client.AuthedHTTPClient;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpMethod;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTestClient
extends AuthedHTTPClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"MyClient");
    private String token = null;

    public MyTestClient(@Nonnull String baseurl, @Nonnull String user, @Nonnull String pass) throws Exception {
        super(baseurl, user, pass);
    }

    @Override
    public boolean addAuthToRequest(@Nullable Request request) {
        request.header("Authorization", "Bearer " + this.token);
        return true;
    }

    @Override
    @CheckForNull
    public String login() {
        Request request = this.createRequest("/user/login", HttpMethod.POST);
        if (request != null) {
            try {
                request.param("username", this.getUserName());
                request.param("password", this.getPassword());
                ContentResponse response = request.send();
                logger.info("login status: {}", (Object)response.getStatus());
                if (response.getStatus() == 200) {
                    return response.getContentAsString();
                }
                logger.info("login message: {}", (Object)response.getContentAsString());
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error("could not get Response for Request", (Throwable)e);
            }
        }
        return null;
    }
}

