/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.client.websocket;

import de.kosmos_lab.web.client.websocket.handlers.IOnConnected;
import de.kosmos_lab.web.client.websocket.handlers.IOnDisconnected;
import de.kosmos_lab.web.client.websocket.handlers.IOnMessage;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class SimpleWebSocketEndpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)"SimpleWebSocketEndpoint");
    Session userSession = null;
    private MessageHandler messageHandler;
    Set<IOnConnected> handlerOnConnect = ConcurrentHashMap.newKeySet();
    Set<IOnMessage> handlerOnMessage = ConcurrentHashMap.newKeySet();
    Set<IOnDisconnected> handlerOnDisconnect = ConcurrentHashMap.newKeySet();
    ConcurrentHashMap<String, Queue<MessageHandler>> mapMessageHandler = new ConcurrentHashMap();
    ConcurrentHashMap<Pattern, Queue<RegexMessageHandler>> getMapMessageHandlerRegex = new ConcurrentHashMap();

    public SimpleWebSocketEndpoint(URI endpointURI) {
        try {
            logger.info("creating new SimpleWebSocketEndpoint for {}", (Object)endpointURI.toString());
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
            Endpoint endpoint = new Endpoint(){

                public void onOpen(Session session, EndpointConfig endpointConfig) {
                    SimpleWebSocketEndpoint.this.userSession = session;
                    SimpleWebSocketEndpoint.this.triggerOnOpen();
                }
            };
            Session session = container.connectToServer(endpoint, cec, endpointURI);
            session.addMessageHandler(String.class, text -> this.onIncomingMessage((String)text));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void triggerOnOpen() {
        for (IOnConnected handler : this.handlerOnConnect) {
            handler.onConnect();
        }
    }

    private void triggerOnMessage(String message) {
        for (IOnMessage handler : this.handlerOnMessage) {
            handler.onMessage(message);
        }
    }

    private void triggerOnMessage(CloseReason closeReason) {
        for (IOnDisconnected handler : this.handlerOnDisconnect) {
            handler.onDisconnected(closeReason);
        }
    }

    public void addHandler(IOnConnected handler) {
        this.handlerOnConnect.add(handler);
    }

    public void addHandler(IOnMessage handler) {
        this.handlerOnMessage.add(handler);
    }

    public void addHandler(IOnDisconnected handler) {
        this.handlerOnDisconnect.add(handler);
    }

    public void addMessageHandler(String message, MessageHandler messageHandler) {
        Queue<MessageHandler> list = this.mapMessageHandler.get(message);
        if (list == null) {
            list = new ConcurrentLinkedQueue<MessageHandler>();
            this.mapMessageHandler.put(message, list);
        }
        list.add(messageHandler);
    }

    public void addMessageHandler(Pattern message, RegexMessageHandler messageHandler) {
        Queue<RegexMessageHandler> list = this.getMapMessageHandlerRegex.get(message);
        if (list == null) {
            list = new ConcurrentLinkedQueue<RegexMessageHandler>();
            this.getMapMessageHandlerRegex.put(message, list);
        }
        list.add(messageHandler);
    }

    @OnOpen
    public void onOpen(Session session) {
        logger.info("opening websocket");
        this.userSession = this.userSession;
        this.triggerOnOpen();
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        logger.info("closing websocket");
        this.userSession = null;
        this.triggerOnMessage(reason);
    }

    @OnMessage
    public void onIncomingMessage(String message) {
        logger.info("got message {}", (Object)message);
        for (Map.Entry<String, Queue<MessageHandler>> entry : this.mapMessageHandler.entrySet()) {
            try {
                if (!entry.getKey().equals(message)) continue;
                for (MessageHandler messageHandler : entry.getValue()) {
                    messageHandler.handleMessage(message);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Map.Entry<Object, Queue<Object>> entry : this.getMapMessageHandlerRegex.entrySet()) {
            try {
                Matcher m = ((Pattern)entry.getKey()).matcher(message);
                if (!m.matches()) continue;
                for (RegexMessageHandler regexMessageHandler : entry.getValue()) {
                    regexMessageHandler.handleMessage(message, m);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.messageHandler != null) {
            this.messageHandler.handleMessage(message);
        }
        this.triggerOnMessage(message);
    }

    @OnMessage
    public void onMessage(ByteBuffer bytes) {
        logger.info("Handle byte buffer");
    }

    public void addMessageHandler(MessageHandler msgHandler) {
        this.messageHandler = msgHandler;
    }

    public void sendMessage(String message) {
        this.userSession.getAsyncRemote().sendText(message);
    }

    public void close() throws IOException {
        this.userSession.close();
    }

    public static interface RegexMessageHandler {
        public void handleMessage(String var1, Matcher var2);
    }

    public static interface MessageHandler {
        public void handleMessage(String var1);
    }
}

