/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.client.websocket;

import de.kosmos_lab.web.client.websocket.SimpleWebSocketEndpoint;
import jakarta.websocket.ClientEndpoint;
import java.net.URI;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class WebSocketTestClient
extends SimpleWebSocketEndpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)"WebSocketTestClient");
    private Queue<String> listMessages = new ConcurrentLinkedQueue<String>();
    ConcurrentHashMap<String, Queue<SimpleWebSocketEndpoint.MessageHandler>> mapMessageHandler = new ConcurrentHashMap();
    ConcurrentHashMap<Pattern, Queue<SimpleWebSocketEndpoint.RegexMessageHandler>> getMapMessageHandlerRegex = new ConcurrentHashMap();
    JSONObject json = new JSONObject();

    public void set(String key, Object value) {
        this.json.put(key, value);
    }

    public JSONObject getObjects() {
        return this.json;
    }

    public WebSocketTestClient(URI endpointURI) {
        super(endpointURI);
        this.addMessageHandler(new SimpleWebSocketEndpoint.MessageHandler(){

            @Override
            public void handleMessage(String message) {
                logger.info("got message: {}", (Object)message);
                WebSocketTestClient.this.listMessages.add(message);
                for (Map.Entry<String, Queue<SimpleWebSocketEndpoint.MessageHandler>> entry : WebSocketTestClient.this.mapMessageHandler.entrySet()) {
                    try {
                        if (!entry.getKey().equals(message)) continue;
                        for (SimpleWebSocketEndpoint.MessageHandler messageHandler : entry.getValue()) {
                            messageHandler.handleMessage(message);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                for (Map.Entry<Object, Queue<Object>> entry : WebSocketTestClient.this.getMapMessageHandlerRegex.entrySet()) {
                    try {
                        Matcher m = ((Pattern)entry.getKey()).matcher(message);
                        if (!m.matches()) continue;
                        for (SimpleWebSocketEndpoint.RegexMessageHandler regexMessageHandler : entry.getValue()) {
                            regexMessageHandler.handleMessage(message, m);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public void addMessageHandler(String message, SimpleWebSocketEndpoint.MessageHandler messageHandler) {
        Queue<SimpleWebSocketEndpoint.MessageHandler> list = this.mapMessageHandler.get(message);
        if (list == null) {
            list = new ConcurrentLinkedQueue<SimpleWebSocketEndpoint.MessageHandler>();
            this.mapMessageHandler.put(message, list);
        }
        list.add(messageHandler);
    }

    public void addMessageHandler(Pattern message, SimpleWebSocketEndpoint.RegexMessageHandler messageHandler) {
        Queue<SimpleWebSocketEndpoint.RegexMessageHandler> list = this.getMapMessageHandlerRegex.get(message);
        if (list == null) {
            list = new ConcurrentLinkedQueue<SimpleWebSocketEndpoint.RegexMessageHandler>();
            this.getMapMessageHandlerRegex.put(message, list);
        }
        list.add(messageHandler);
    }

    public boolean hasMessage(String message) {
        return this.listMessages.contains(message);
    }
}

