/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.client.websocket;

import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class SimpleWebSocketEndpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)"SimpleWebSocketEndpoint");
    Session userSession = null;
    private MessageHandler messageHandler;

    public SimpleWebSocketEndpoint(URI endpointURI) {
        try {
            logger.info("creating new SimpleWebSocketEndpoint for {}", (Object)endpointURI.toString());
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.connectToServer((Object)this, endpointURI);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @OnOpen
    public void onOpen(Session userSession) {
        logger.info("opening websocket");
        this.userSession = userSession;
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        logger.info("closing websocket");
        this.userSession = null;
    }

    @OnMessage
    public void onMessage(String message) {
        if (this.messageHandler != null) {
            this.messageHandler.handleMessage(message);
        }
    }

    @OnMessage
    public void onMessage(ByteBuffer bytes) {
        logger.info("Handle byte buffer");
    }

    public void addMessageHandler(MessageHandler msgHandler) {
        this.messageHandler = msgHandler;
    }

    public void sendMessage(String message) {
        this.userSession.getAsyncRemote().sendText(message);
    }

    public void close() throws IOException {
        this.userSession.close();
    }

    public static interface RegexMessageHandler {
        public void handleMessage(String var1, Matcher var2);
    }

    public static interface MessageHandler {
        public void handleMessage(String var1);
    }
}

