/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server.servlets.openapi;

import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.server.WebServer;
import de.kosmos_lab.web.server.servlets.BaseServlet;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import de.kosmos_lab.web.server.servlets.openapi.OpenApiYamlServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/doc/openapi.json", userLevel=-1)
public class OpenApiJSONServlet
extends BaseServlet {
    public String cached = null;

    public OpenApiJSONServlet(WebServer webServer) {
        super(webServer);
    }

    @Override
    @Operation(tags={"OpenApi"}, summary="openapi.json", description="The generated openApi specification for this service in JSONObject format", responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="The generated openApi specification for this service")})
    public void get(BaseServletRequest request, HttpServletResponse response) throws IOException {
        if (this.cached == null) {
            this.cached = OpenApiYamlServlet.parser.getJSON().toString(2);
        }
        String host = null;
        try {
            host = request.getRequest().getHeader("host");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (host != null) {
            OpenApiJSONServlet.sendJSON(request, response, this.server.replaceHostName(this.cached, host));
        } else {
            OpenApiJSONServlet.sendJSON(request, response, this.cached);
        }
    }
}

