/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server.servlets.openapi;

import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.server.WebServer;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import de.kosmos_lab.web.server.servlets.openapi.AsyncApiYamlServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/doc/asyncapi.json", userLevel=-1)
public class AsyncApiJSONServlet
extends AsyncApiYamlServlet {
    public String cached = null;

    public AsyncApiJSONServlet(WebServer webServer) {
        super(webServer);
    }

    @Override
    @Operation(tags={"asyncApi"}, summary="asyncapi.json", description="The generated asyncApi specification for this service in JSONObject format", responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="The generated asyncApi specification for this service")})
    public void get(BaseServletRequest request, HttpServletResponse response) throws IOException {
        if (this.cached == null) {
            this.cached = parser.getJSON().toString(2);
        }
        String host = null;
        try {
            host = request.getRequest().getHeader("host");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (host != null) {
            AsyncApiJSONServlet.sendJSON(request, response, this.server.replaceHostName(this.cached, host));
        } else {
            AsyncApiJSONServlet.sendJSON(request, response, this.cached);
        }
    }
}

