/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server;

import de.kosmos_lab.web.server.WebServer;
import io.netty.util.internal.ConcurrentSet;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketService {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketService.class);
    protected ConcurrentSet<Session> sessions = new ConcurrentSet();
    protected final WebServer server;

    public WebSocketService(WebServer server) {
        this.server = server;
    }

    @OnWebSocketConnect
    public void addWebSocketClient(Session session) {
        logger.info("got new client {}", (Object)session);
        this.sessions.add((Object)session);
    }

    @OnWebSocketClose
    public void delWebSocketClient(Session session) {
        logger.info("lost client {}", (Object)session);
        this.sessions.remove((Object)session);
    }

    public abstract void onWebSocketMessage(Session var1, String var2);

    public boolean serverIsStopped() {
        return this.server.isStopped();
    }

    public void broadCast(String message) {
        for (Session session : this.sessions) {
            try {
                session.getRemote().sendString(message);
            }
            catch (EofException eofException) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void ping() {
        this.broadCast(new JSONObject().put("type", (Object)"ping").toString());
    }

    public static class Pinger
    extends Thread {
        private final WebSocketService socket;

        public Pinger(WebSocketService socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            while (!this.socket.serverIsStopped()) {
                this.socket.ping();
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

