/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server;

import ch.qos.logback.classic.Level;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import de.kosmos_lab.web.annotations.ExternalDocumentation;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.AdditionalProperties;
import de.kosmos_lab.web.annotations.enums.Explode;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.headers.Header;
import de.kosmos_lab.web.annotations.info.AsyncInfo;
import de.kosmos_lab.web.annotations.info.Contact;
import de.kosmos_lab.web.annotations.info.Info;
import de.kosmos_lab.web.annotations.info.License;
import de.kosmos_lab.web.annotations.media.ArraySchema;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.DiscriminatorMapping;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.ObjectSchema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.annotations.security.OAuthFlow;
import de.kosmos_lab.web.annotations.security.OAuthFlows;
import de.kosmos_lab.web.annotations.security.Scope;
import de.kosmos_lab.web.annotations.security.SecurityRequirement;
import de.kosmos_lab.web.annotations.security.SecuritySchema;
import de.kosmos_lab.web.annotations.servers.Server;
import de.kosmos_lab.web.annotations.tags.Tag;
import de.kosmos_lab.web.data.Tuple;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ApiResponseDescription;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.server.Example;
import de.kosmos_lab.web.server.WebServer;
import jakarta.servlet.http.HttpServlet;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiParser {
    private static OpenApiParser instance = null;
    public final HashSet<String> missingFromResource = new HashSet();
    protected final Logger logger = LoggerFactory.getLogger((String)"OpenApiParser");
    protected final WebServer server;
    private final String formatRegex = "%\\{(?<key>.*?)\\}";
    private final Pattern formatPattern = Pattern.compile(".*?(%\\{(?<key>.*?)\\}).*+");
    private JSONObject json = null;
    private HashSet<de.kosmos_lab.web.annotations.media.Schema> schemas = new HashSet();
    private HashSet<ObjectSchema> oschemas = new HashSet();
    private HashSet<ArraySchema> aschemas = new HashSet();
    private HashSet<Parameter> parameters = new HashSet();
    private HashSet<Tag> tags = new HashSet();
    private ResourceBundle labels = null;
    private HashMap<String, JSONObject> mResponses = new HashMap();
    private JSONObject components = new JSONObject();
    private LinkedList<Example> examples = new LinkedList();
    private JSONObject responses = new JSONObject();

    public OpenApiParser(WebServer server) {
        this.server = server;
    }

    public static OpenApiParser getInstance(WebServer server) {
        if (instance == null) {
            instance = new OpenApiParser(server);
        }
        return instance;
    }

    public Set<Class<? extends HttpServlet>> getServlets() {
        return this.server.servlets;
    }

    public String asYaml(String jsonString) throws JsonProcessingException, IOException {
        JsonNode jsonNodeTree = new ObjectMapper().readTree(jsonString);
        String jsonAsYaml = new YAMLMapper().writeValueAsString((Object)jsonNodeTree);
        return jsonAsYaml;
    }

    public synchronized String getYAML() throws IOException {
        return this.asYaml(this.getJSON().toString());
    }

    public JSONObject toJSON(AsyncInfo info) {
        JSONObject jinfo = new JSONObject();
        this.add("description", info.description(), jinfo);
        this.add("contact", info.contact(), jinfo);
        this.add("termsOfService", info.termsOfService(), jinfo);
        this.add("title", info.title(), jinfo);
        this.add("version", info.version(), jinfo);
        this.add("license", info.license(), jinfo);
        return jinfo;
    }

    public JSONObject toJSON(Info info) {
        JSONObject jinfo = new JSONObject();
        this.add("description", info.description(), jinfo);
        this.add("contact", info.contact(), jinfo);
        this.add("termsOfService", info.termsOfService(), jinfo);
        this.add("title", info.title(), jinfo);
        this.add("version", info.version(), jinfo);
        this.add("license", info.license(), jinfo);
        return jinfo;
    }

    public void add(String tag, License license, JSONObject json) {
        JSONObject licenseJSON = new JSONObject();
        this.add("url", license.url(), licenseJSON);
        this.add("name", license.name(), licenseJSON);
        this.add(tag, licenseJSON, json);
    }

    public void add(String tag, Contact contact, JSONObject json) {
        JSONObject contactJSON = new JSONObject();
        this.add("email", contact.email(), contactJSON);
        this.add("url", contact.url(), contactJSON);
        this.add("name", contact.name(), contactJSON);
        this.add(tag, contactJSON, json);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized JSONObject getJSON() {
        int n;
        if (this.json != null) {
            return this.json;
        }
        this.json = new JSONObject();
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.reflections")).setLevel(Level.OFF);
        this.add("openapi", "3.0.3", this.json);
        JSONObject info = new JSONObject();
        Info infoAnnotation = this.server.getClass().getAnnotation(Info.class);
        if (infoAnnotation != null) {
            info = this.toJSON(infoAnnotation);
        }
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Reflections[] model = reader.read((Reader)new FileReader("pom.xml"));
            info.put("version", (Object)model.getVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.add("info", info, this.json);
        JSONArray servers = new JSONArray();
        for (Reflections r : new Reflections[]{new Reflections("", new Scanner[0]), new Reflections("de.kosmos_lab.web.exceptions", new Scanner[0])}) {
            int n2;
            Annotation[] annotationArray;
            for (Class clazz : r.getTypesAnnotatedWith(ApiResponse.class)) {
                annotationArray = (ApiResponse[])clazz.getAnnotationsByType(ApiResponse.class);
                n2 = annotationArray.length;
                for (n = 0; n < n2; ++n) {
                    Annotation annotation = annotationArray[n];
                    if (Exception.class.isAssignableFrom(clazz)) {
                        this.responses.put(clazz.getSimpleName().replace("Exception", "Error"), (Object)this.toJSON((ApiResponse)annotation));
                    }
                    if (annotation.componentName().length() <= 0) continue;
                    this.responses.put(annotation.componentName(), (Object)this.toJSON((ApiResponse)annotation));
                }
            }
            for (Class clazz : r.getTypesAnnotatedWith(ApiResponseDescription.class)) {
                annotationArray = (ApiResponseDescription[])clazz.getAnnotationsByType(ApiResponseDescription.class);
                n2 = annotationArray.length;
                for (n = 0; n < n2; ++n) {
                    Annotation annotation = annotationArray[n];
                    if (annotation.name().length() <= 0) continue;
                    this.responses.put(annotation.name(), (Object)new JSONObject().put("description", (Object)annotation.description()));
                }
            }
            for (Class clazz : r.getTypesAnnotatedWith(Server.class)) {
                annotationArray = (Server[])clazz.getAnnotationsByType(Server.class);
                n2 = annotationArray.length;
                for (n = 0; n < n2; ++n) {
                    Annotation annotation = annotationArray[n];
                    this.logger.info("found server {}", (Object)annotation);
                    JSONObject jSONObject = new JSONObject();
                    this.add("description", annotation.description(), jSONObject);
                    this.add("url", annotation.url(), jSONObject);
                    servers.put((Object)jSONObject);
                }
            }
        }
        JSONObject securitySchemes = new JSONObject();
        for (de.kosmos_lab.web.annotations.media.Schema schema : (de.kosmos_lab.web.annotations.media.Schema[])this.server.getClass().getAnnotationsByType(de.kosmos_lab.web.annotations.media.Schema.class)) {
            String string = schema.name();
            if (string.length() <= 0) continue;
            this.schemas.add(schema);
        }
        for (Annotation annotation : (ObjectSchema[])this.server.getClass().getAnnotationsByType(ObjectSchema.class)) {
            String string = annotation.componentName();
            if (string.length() <= 0) continue;
            this.oschemas.add((ObjectSchema)annotation);
        }
        for (Annotation annotation : (SecuritySchema[])this.server.getClass().getAnnotationsByType(SecuritySchema.class)) {
            void var9_40;
            String string = annotation.componentName();
            if (string.length() == 0) {
                String string2 = annotation.name();
            }
            if (var9_40.length() <= 0) continue;
            Annotation[] schemaJSON = new JSONObject();
            this.add("name", annotation.name(), (JSONObject)schemaJSON);
            this.add("description", annotation.description(), (JSONObject)schemaJSON);
            this.add("scheme", annotation.scheme(), (JSONObject)schemaJSON);
            this.add("openIdConnectUrl", annotation.openIdConnectUrl(), (JSONObject)schemaJSON);
            this.add("bearerFormat", annotation.bearerFormat(), (JSONObject)schemaJSON);
            this.add("type", annotation.type().toString(), (JSONObject)schemaJSON);
            this.add("in", annotation.in().toString(), (JSONObject)schemaJSON);
            this.add("flows", annotation.flows(), (JSONObject)schemaJSON);
            this.add((String)var9_40, (JSONObject)schemaJSON, securitySchemes);
        }
        this.add("securitySchemes", securitySchemes, this.components);
        this.responses = new JSONObject();
        for (Annotation annotation : (Server[])this.server.getClass().getAnnotationsByType(Server.class)) {
            this.logger.info("found server {}", (Object)annotation);
            JSONObject jSONObject = new JSONObject();
            this.add("description", annotation.description(), jSONObject);
            this.add("url", annotation.url(), jSONObject);
            servers.put((Object)jSONObject);
        }
        if (servers.length() == 0) {
            servers.put((Object)new JSONObject().put("url", (Object)"http://none").put("description", (Object)"current host"));
        }
        this.add("servers", servers, this.json);
        JSONObject schemajson = new JSONObject();
        JSONObject parametersjson = new JSONObject();
        JSONObject paths = new JSONObject();
        for (Class<? extends HttpServlet> clazz : this.getServlets()) {
            void var13_77;
            void var13_75;
            void var13_73;
            void var13_71;
            void var13_69;
            for (ApiResponseDescription apiResponseDescription : (ApiResponseDescription[])clazz.getAnnotationsByType(ApiResponseDescription.class)) {
                if (apiResponseDescription.name().length() <= 0) continue;
                this.responses.put(apiResponseDescription.name(), (Object)new JSONObject().put("description", (Object)apiResponseDescription.description()));
            }
            for (Annotation annotation : (ApiResponse[])clazz.getAnnotationsByType(ApiResponse.class)) {
                if (Exception.class.isAssignableFrom(clazz)) {
                    this.responses.put(clazz.getSimpleName().replace("Exception", "Error"), (Object)this.toJSON((ApiResponse)annotation));
                }
                if (annotation.componentName().length() <= 0) continue;
                this.responses.put(annotation.componentName(), (Object)this.toJSON((ApiResponse)annotation));
            }
            ApiEndpoint a = clazz.getAnnotation(ApiEndpoint.class);
            if (a != null && !a.hidden()) {
                void var13_67;
                this.logger.info("found {}", (Object)a);
                Method[] methodArray = clazz.getDeclaredMethods();
                n = methodArray.length;
                boolean bl = false;
                while (var13_67 < n) {
                    Method method = methodArray[var13_67];
                    for (String method2 : new String[]{"get", "post", "delete"}) {
                        try {
                            Operation am;
                            if (!method.getName().equals(method2) || (am = method.getAnnotation(Operation.class)) == null) continue;
                            this.add(a, am, method, paths);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    ++var13_67;
                }
            }
            this.add("paths", paths, this.json);
            Annotation[] annotationArray = (ObjectSchema[])clazz.getAnnotationsByType(ObjectSchema.class);
            n = annotationArray.length;
            boolean bl = false;
            while (var13_69 < n) {
                ObjectSchema objectSchema = annotationArray[var13_69];
                this.oschemas.add(objectSchema);
                ++var13_69;
            }
            annotationArray = (ArraySchema[])clazz.getAnnotationsByType(ArraySchema.class);
            n = annotationArray.length;
            boolean bl2 = false;
            while (var13_71 < n) {
                Annotation annotation = annotationArray[var13_71];
                this.aschemas.add((ArraySchema)annotation);
                ++var13_71;
            }
            annotationArray = (de.kosmos_lab.web.annotations.media.Schema[])clazz.getAnnotationsByType(de.kosmos_lab.web.annotations.media.Schema.class);
            n = annotationArray.length;
            boolean bl3 = false;
            while (var13_73 < n) {
                Annotation annotation = annotationArray[var13_73];
                this.schemas.add((de.kosmos_lab.web.annotations.media.Schema)annotation);
                ++var13_73;
            }
            annotationArray = (Parameter[])clazz.getAnnotationsByType(Parameter.class);
            n = annotationArray.length;
            boolean bl4 = false;
            while (var13_75 < n) {
                Annotation annotation = annotationArray[var13_75];
                this.parameters.add((Parameter)annotation);
                ++var13_75;
            }
            annotationArray = (Tag[])clazz.getAnnotationsByType(Tag.class);
            n = annotationArray.length;
            boolean bl5 = false;
            while (var13_77 < n) {
                Annotation annotation = annotationArray[var13_77];
                this.tags.add((Tag)annotation);
                ++var13_77;
            }
        }
        for (ArraySchema arraySchema : this.aschemas) {
            this.add(arraySchema.name(), this.toJSON(arraySchema), schemajson);
        }
        for (ObjectSchema objectSchema : this.oschemas) {
            this.add(objectSchema.componentName(), this.toJSON(objectSchema), schemajson);
        }
        for (de.kosmos_lab.web.annotations.media.Schema schema : this.schemas) {
            this.add(schema.name(), schema, schemajson);
        }
        for (Parameter parameter : this.parameters) {
            String name2 = parameter.componentName();
            if (name2.length() == 0) {
                name2 = parameter.name();
            }
            if (name2.length() <= 0) continue;
            this.add(name2, this.toJSON(parameter), parametersjson);
        }
        this.add("tags", this.tags, this.json);
        this.add("schemas", schemajson, this.components);
        this.add("responses", this.responses, this.components);
        this.add("parameters", parametersjson, this.components);
        this.add("components", this.components, this.json);
        this.checkExamples();
        return this.json;
    }

    public void add(String tag, Tag[] tags, JSONObject json) {
        JSONArray tagarray = new JSONArray();
        for (Tag t : tags) {
            this.add(t, tagarray);
        }
        json.put(tag, (Object)tagarray);
    }

    public void add(String tag, HashSet<Tag> tags, JSONObject json) {
        JSONArray tagarray = new JSONArray();
        for (Tag t : tags) {
            this.add(t, tagarray);
        }
        json.put(tag, (Object)tagarray);
    }

    public JSONObject toJSON(ObjectSchema p) {
        JSONObject pjson = this.toJSON(p.properties());
        if (p.additionalProperties() == AdditionalProperties.TRUE) {
            pjson.put("additionalProperties", true);
        } else if (p.additionalProperties() == AdditionalProperties.FALSE) {
            pjson.put("additionalProperties", false);
        }
        JSONArray ex = new JSONArray();
        for (ExampleObject e : p.examples()) {
            if (e.value().length() <= 0) continue;
            ex.put(this.parseValue(e.value()));
        }
        this.add("examples", ex, pjson);
        return pjson;
    }

    public Tuple checkExamples() {
        int failed = 0;
        int checked = 0;
        for (Example ex : this.examples) {
            if (!this.checkExample(ex.value, this.createJSONSchemaFromSchema(ex.schema), ex.type)) {
                this.logger.error("Example failed! {} {}", (Object)ex.schema, (Object)ex.value);
                ++failed;
            } else {
                this.logger.info("Example did pass! {} {}", (Object)ex.schema, (Object)ex.value);
            }
            ++checked;
        }
        if (failed > 0) {
            this.logger.error("Had {} Examples that failed", (Object)failed);
        }
        return new Tuple<Integer, Integer>(checked, failed);
    }

    public void add(String tag, OAuthFlows flows, JSONObject json) {
        JSONObject flowsJSON = new JSONObject();
        this.add("implicit", flows.implicit(), flowsJSON);
        this.add("password", flows.password(), flowsJSON);
        this.add("clientCredentials", flows.clientCredentials(), flowsJSON);
        this.add("authorizationCode", flows.authorizationCode(), flowsJSON);
    }

    public void add(String tag, OAuthFlow flow, JSONObject json) {
        JSONObject flowJSON = new JSONObject();
        this.add("authorizationUrl", flow.authorizationUrl(), flowJSON);
        this.add("tokenUrl", flow.tokenUrl(), flowJSON);
        this.add("refreshUrl", flow.refreshUrl(), flowJSON);
        JSONObject scopesJSON = new JSONObject();
        for (Scope scope : flow.scopes()) {
            scopesJSON.put(scope.name(), (Object)scope.value());
        }
        this.add("scopes", scopesJSON, flowJSON);
        this.add(tag, flowJSON, json);
    }

    public void add(Tag tag, JSONArray array) {
        JSONObject j = new JSONObject();
        this.add("name", tag.name(), j);
        this.add("description", tag.description(), j);
        this.add("externalDocs", tag.externalDocs(), j);
        if (j.length() > 0) {
            array.put((Object)j);
        }
    }

    public void add(ApiEndpoint endpoint, Operation operation, Method method, JSONObject paths) {
        JSONArray security;
        JSONObject j;
        block18: {
            block16: {
                block17: {
                    JSONObject epp = paths.optJSONObject(endpoint.path());
                    if (epp == null) {
                        epp = new JSONObject();
                        paths.put(endpoint.path(), (Object)epp);
                    }
                    j = new JSONObject();
                    epp.put(method.getName(), (Object)j);
                    this.add("tags", operation.tags(), j);
                    if (operation.description().length() > 0) {
                        this.add("description", operation.description(), j);
                    } else {
                        this.add("description", operation.summary(), j);
                    }
                    this.add("summary", operation.summary(), j);
                    Object operationId = operation.operationId();
                    if (((String)operationId).length() == 0) {
                        operationId = method.getName() + "-" + endpoint.path().replace("/", "");
                    }
                    this.add("operationId", (String)operationId, j);
                    security = new JSONArray();
                    if (operation.security().length != 0) break block16;
                    if (endpoint.userLevel() < 100) break block17;
                    security.put((Object)new JSONObject().put("bearerAuth", (Object)new JSONArray().put((Object)"admin")));
                    security.put((Object)new JSONObject().put("basicAuth", (Object)new JSONArray().put((Object)"admin")));
                    break block18;
                }
                if (endpoint.userLevel() < 0) break block18;
                security.put((Object)new JSONObject().put("bearerAuth", (Object)new JSONArray().put((Object)"user")));
                security.put((Object)new JSONObject().put("basicAuth", (Object)new JSONArray().put((Object)"user")));
                break block18;
            }
            for (SecurityRequirement s : operation.security()) {
                JSONArray scopes = new JSONArray();
                for (String scope : s.scopes()) {
                    scopes.put((Object)scope);
                }
                security.put((Object)new JSONObject().put(s.name(), (Object)scopes));
            }
        }
        this.add("security", security, j);
        JSONObject resp = new JSONObject();
        if (operation.responses().length > 0) {
            for (ApiResponse response : operation.responses()) {
                JSONObject rjson = this.toJSON(response);
                ResponseCode sc = response.responseCode();
                if (sc.statusCode() != -1) {
                    resp.put(String.valueOf(sc.statusCode()), (Object)rjson);
                    continue;
                }
                resp.put(String.valueOf(sc.status()), (Object)rjson);
            }
        }
        try {
            for (Class<?> ex : method.getExceptionTypes()) {
                this.logger.info("{} throws exception {}:", (Object)endpoint.path(), (Object)ex.getSimpleName());
                String n = ex.getSimpleName().replace("Exception", "Error");
                this.addException(n, ex, resp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (endpoint.userLevel() != -1) {
            // empty if block
        }
        j.put("responses", (Object)resp);
        JSONArray params = new JSONArray();
        for (Parameter p : operation.parameters()) {
            this.add(p, params);
        }
        if (params.length() > 0) {
            j.put("parameters", (Object)params);
        }
        JSONObject requestBody = new JSONObject();
        this.add("content", operation.requestBody().content(), requestBody);
        if (requestBody.length() > 0) {
            j.put("requestBody", (Object)requestBody);
        }
    }

    protected void addException(String n, Class<?> ex, JSONObject resp) {
        ApiResponse apiresp = ex.getAnnotation(ApiResponse.class);
        if (apiresp != null) {
            ResponseCode sc;
            this.logger.info("Found ApiResponse for {} {}", (Object)ex.getSimpleName(), (Object)apiresp);
            if (apiresp.componentName().length() > 0) {
                n = apiresp.componentName();
            }
            if (!this.responses.has(n)) {
                this.responses.put(n, (Object)this.toJSON(apiresp));
            }
            if ((sc = apiresp.responseCode()).statusCode() != -1) {
                String ssc = String.valueOf(sc.statusCode());
                if (!resp.has(ssc)) {
                    resp.put(ssc, (Object)new JSONObject().put("$ref", (Object)("#/components/responses/" + n)));
                }
            } else {
                String ssc = String.valueOf(sc.status());
                if (!resp.has(ssc)) {
                    resp.put(ssc, (Object)new JSONObject().put("$ref", (Object)("#/components/responses/" + n)));
                }
            }
        } else if (ex.getSuperclass() != null) {
            this.logger.info("Found NO ApiResponse for {} - now looking for {}", (Object)ex.getSimpleName(), ex.getSuperclass());
            this.addException(n, ex.getSuperclass(), resp);
        } else {
            this.logger.info("Found NO ApiResponse for {} - {}", (Object)ex.getSimpleName(), (Object)ex.getCanonicalName());
        }
    }

    private JSONObject toJSON(ApiResponse response) {
        JSONObject rjson = new JSONObject();
        this.add("description", response.description(), rjson);
        if (response.ref().length() > 0) {
            JSONObject o = this.mResponses.get(response.ref());
            if (o != null) {
                return o;
            }
            this.add("$ref", response.ref(), rjson);
        }
        this.add("content", response.content(), rjson);
        this.add("headers", response.headers(), rjson);
        return rjson;
    }

    public JSONObject toJSON(ArraySchema arraySchema) {
        JSONObject schema = new JSONObject();
        this.add("items", arraySchema.arraySchema(), schema);
        this.add("items", arraySchema.schema(), schema);
        this.add("minItems", arraySchema.minItems(), schema, Integer.MAX_VALUE);
        this.add("maxItems", arraySchema.maxItems(), schema, Integer.MIN_VALUE);
        this.add("uniqueItems", arraySchema.uniqueItems(), schema, (Boolean)false);
        if (schema.length() > 0) {
            this.add("type", "array", schema);
            if (schema.has("items")) {
                schema.getJSONObject("items").remove("description");
            }
            this.add("description", arraySchema.schema().description(), schema);
            this.add("description", arraySchema.arraySchema().description(), schema);
        }
        return schema;
    }

    public JSONObject createJSONSchemaFromSchema(JSONObject schema) {
        return new JSONObject().put("components", (Object)new JSONObject().put("schemas", (Object)this.components.optJSONObject("schemas"))).put("$schema", (Object)"http://json-schema.org/draft-07/schema#").put("type", (Object)"object").put("properties", (Object)new JSONObject().put("value", (Object)schema)).put("additionalProperties", false).put("required", (Object)new JSONArray().put((Object)"value"));
    }

    public boolean checkExample(String value, JSONObject schema, SchemaType type) {
        JSONObject v = null;
        try {
            Schema s = SchemaLoader.load((JSONObject)schema);
            if (type == SchemaType.DEFAULT) {
                if (value.startsWith("{")) {
                    type = SchemaType.OBJECT;
                } else if (value.startsWith("[")) {
                    type = SchemaType.ARRAY;
                }
            }
            switch (type) {
                case STRING: {
                    v = new JSONObject().put("value", (Object)value);
                    s.validate((Object)v);
                    return true;
                }
                case INTEGER: {
                    v = new JSONObject().put("value", Integer.parseInt(value));
                    s.validate((Object)v);
                    return true;
                }
                case NUMBER: {
                    v = new JSONObject().put("value", Double.parseDouble(value));
                    s.validate((Object)v);
                    return true;
                }
                case ARRAY: {
                    v = new JSONObject().put("value", (Object)new JSONArray(value));
                    s.validate((Object)v);
                    return true;
                }
                case BOOLEAN: {
                    v = new JSONObject().put("value", Boolean.parseBoolean(value));
                    s.validate((Object)v);
                    return true;
                }
                case OBJECT: {
                    v = new JSONObject().put("value", (Object)new JSONObject(value));
                    s.validate((Object)v);
                    return true;
                }
            }
            this.logger.warn("DID NOT TEST {}", (Object)value);
        }
        catch (Exception ex) {
            this.logger.error("FAILED TO CHECK \nRaw:{}\nValue: {}\n Schema: {}\nReason:{}", new Object[]{value, v, schema, ex.getMessage(), ex});
        }
        return false;
    }

    public boolean checkExample(ExampleObject e, JSONObject schema, SchemaType type) {
        String value = e.value();
        if (e.value().length() == 0) {
            value = e.name();
        }
        return this.checkExample(value, schema, type);
    }

    public JSONObject getExamplesObject(ExampleObject[] examples) {
        LinkedList<ExampleObject> ex = new LinkedList<ExampleObject>();
        for (ExampleObject e : examples) {
            ex.add(e);
        }
        return this.getExamplesObject(ex);
    }

    public JSONObject getExamplesObject(List<ExampleObject> examples) {
        HashMap<String, String> ex = new HashMap<String, String>();
        for (ExampleObject e : examples) {
            ex.put(e.value(), e.name());
        }
        return this.getExamplesObject(ex);
    }

    public JSONObject getExamplesObject(HashMap<String, String> examples) {
        JSONObject ex = new JSONObject();
        int emptynames = 0;
        for (Map.Entry<String, String> entry : examples.entrySet()) {
            String name = entry.getValue();
            if (name == null || name.length() == 0) {
                name = String.format("Example %d", ++emptynames);
            }
            ex.put(name, (Object)new JSONObject().put("value", (Object)entry.getKey()));
        }
        return ex;
    }

    public JSONArray getExamplesArray(ExampleObject[] examples) {
        LinkedList<ExampleObject> ex = new LinkedList<ExampleObject>();
        for (ExampleObject e : examples) {
            ex.add(e);
        }
        return this.getExamplesArray(ex);
    }

    public JSONArray getExamplesArray(List<ExampleObject> examples) {
        HashMap<String, String> ex = new HashMap<String, String>();
        for (ExampleObject e : examples) {
            ex.put(e.value(), e.name());
        }
        return this.getExamplesArray(ex);
    }

    public JSONArray getExamplesArray(HashMap<String, String> examples) {
        JSONArray ex = new JSONArray();
        int emptynames = 0;
        for (Map.Entry<String, String> entry : examples.entrySet()) {
            String name = entry.getValue();
            if (name == null || name.length() == 0) {
                name = String.format("Example %d", ++emptynames);
            }
            ex.put(this.parseValue(entry.getKey()));
        }
        return ex;
    }

    public JSONObject toJSON(Parameter p) {
        JSONObject pjson = new JSONObject();
        if (p.ref().length() > 0) {
            this.add("$ref", p.ref(), pjson);
        } else {
            this.add("description", p.description(), pjson);
            this.add("name", p.name(), pjson);
            JSONObject schema = this.toJSON(p.schema());
            HashMap<String, String> allExamples = this.extractExamples(p);
            this.add("examples", this.getExamplesObject(allExamples), pjson);
            if (schema.length() > 0) {
                this.add("schema", schema, pjson);
                Object j = null;
                for (String e : allExamples.keySet()) {
                    this.examples.add(new Example(e, schema, p.schema().type()));
                }
                try {
                    if (p.example().length() > 0) {
                        this.examples.add(new Example(p.example(), schema, p.schema().type()));
                    }
                    if (p.examples().length > 0) {
                        for (ExampleObject e : p.examples()) {
                            String v = e.value();
                            if (v.length() == 0) {
                                v = e.name();
                            }
                            if (v.length() <= 0) continue;
                            this.examples.add(new Example(v, schema, p.schema().type()));
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("COULD NOT PARSE SCHEMA! {}", j, (Object)e);
                }
            }
            if (p.explode() == Explode.TRUE) {
                this.add("explode", true, pjson, null);
            } else if (p.explode() == Explode.FALSE) {
                this.add("explode", false, pjson, null);
            }
            this.add("example", p.example(), pjson);
            this.add("required", p.required(), pjson, null);
            this.add("deprecated", p.deprecated(), pjson, (Boolean)false);
            this.add("allowEmptyValue", p.allowEmptyValue(), pjson, (Boolean)false);
            this.add("in", p.in().toString(), pjson);
            this.add("style", p.style().toString(), pjson);
            this.add("allowReserved", p.allowReserved(), pjson, (Boolean)false);
            this.add("content", p.content(), pjson);
            this.add("schema", this.toJSON(p.array()), pjson);
            this.add("hidden", p.hidden(), pjson, (Boolean)false);
        }
        return pjson;
    }

    public void add(Parameter p, JSONArray params) {
        params.put((Object)this.toJSON(p));
    }

    public JSONObject toJSON(SchemaProperty[] properties) {
        JSONObject schemajson = new JSONObject();
        schemajson.put("type", (Object)"object");
        JSONObject propjson = new JSONObject();
        JSONArray reqarray = new JSONArray();
        for (SchemaProperty sp : properties) {
            this.add(sp.name(), sp.schema(), propjson);
            JSONObject sj = this.toJSON(sp.array());
            if (sj != null) {
                this.add(sp.name(), sj, propjson);
            }
            if (sp.schema().required()) {
                reqarray.put((Object)sp.name());
                continue;
            }
            if (sp.array().schema().required()) {
                reqarray.put((Object)sp.name());
                continue;
            }
            if (!sp.array().arraySchema().required()) continue;
            reqarray.put((Object)sp.name());
        }
        if (propjson.length() > 0) {
            schemajson.put("properties", (Object)propjson);
        }
        if (reqarray.length() > 0) {
            schemajson.put("required", (Object)reqarray);
        }
        return schemajson;
    }

    public void add(String tag, SchemaProperty[] properties, JSONObject json) {
        json.put(tag, (Object)this.toJSON(properties));
    }

    public void add(String tag, Content[] value, JSONObject json) {
        if (value.length > 0) {
            JSONObject contentjson = new JSONObject();
            for (Content c : value) {
                if (c.mediaType().length() <= 0) continue;
                JSONObject cjson = new JSONObject();
                this.add("schema", this.toJSON(c.array()), cjson);
                if (!cjson.has("schema")) {
                    if (c.schemaProperties().length > 0) {
                        this.add("schema", c.schemaProperties(), cjson);
                    }
                    if (!cjson.has("schema")) {
                        this.add("schema", this.toJSON(c.schema()), cjson);
                    }
                }
                if (c.examples().length > 0) {
                    this.add("examples", c.examples(), cjson);
                }
                if (cjson.length() > 0) {
                    contentjson.put(c.mediaType(), (Object)cjson);
                }
                Object j = null;
                try {
                    if (c.examples().length <= 0) continue;
                    if (cjson.has("schema")) {
                        for (ExampleObject e : c.examples()) {
                            String v = e.value();
                            if (v.length() == 0) {
                                v = e.name();
                            }
                            if (v.length() <= 0) continue;
                            this.examples.add(new Example(v, cjson.getJSONObject("schema"), c.schema().type()));
                        }
                        continue;
                    }
                    this.logger.warn("no schema for {}", (Object)c);
                }
                catch (Exception e) {
                    this.logger.error("COULD NOT PARSE SCHEMA! {}", j, (Object)e);
                }
            }
            if (contentjson.length() > 0) {
                json.put(tag, (Object)contentjson);
            }
        }
    }

    public void add(String tag, Header[] value, JSONObject json) {
        if (value.length > 0) {
            JSONObject contentjson = new JSONObject();
            for (Header c : value) {
                if (c.description().length() <= 0) continue;
                JSONObject cjson = new JSONObject();
                this.add("description", c.description(), cjson);
                this.add("schema", this.toJSON(c.schema()), cjson);
                if (c.deprecated()) {
                    this.add("deprecated", String.valueOf(c.deprecated()), cjson);
                }
                this.add("$ref", c.ref(), cjson);
                if (cjson.length() <= 0) continue;
                contentjson.put(c.name(), (Object)cjson);
            }
            if (contentjson.length() > 0) {
                json.put(tag, (Object)contentjson);
            }
        }
    }

    public JSONObject toJSON(ExampleObject example) {
        JSONObject json = new JSONObject();
        if (example.ref().length() > 0) {
            this.add("$ref", example.ref(), json);
        } else {
            this.add("summary", example.summary(), json);
            this.add("description", example.description(), json);
            this.add("value", example.value(), json, true);
            if (!json.has("value")) {
                this.add("value", example.value(), json);
            }
            if (!json.has("value")) {
                this.add("value", example.name(), json);
            }
            this.add("externalValue", example.externalValue(), json);
        }
        return json;
    }

    public void add(String tag, ExampleObject[] examples, JSONObject json) {
        JSONObject ex = new JSONObject();
        for (ExampleObject e : examples) {
            String name = e.name();
            if (name.length() == 0) {
                name = e.value();
            }
            ex.put(name, (Object)this.toJSON(e));
        }
        if (ex.length() > 0) {
            json.put(tag, (Object)ex);
        }
    }

    public JSONObject toJSON(de.kosmos_lab.web.annotations.media.Schema schema) {
        JSONObject sjson = new JSONObject();
        if (schema.ref().length() > 0) {
            this.add("$ref", schema.ref(), sjson);
        } else {
            JSONArray jsonArray;
            this.add("type", schema.type().toString(), sjson);
            this.add("hidden", schema.hidden(), sjson, (Boolean)false);
            this.add("not", schema.not(), sjson);
            if (schema.notRef().length > 0) {
                jsonArray = new JSONArray();
                for (String ref : schema.notRef()) {
                    jsonArray.put((Object)new JSONObject().put("$ref", (Object)ref));
                }
                this.add("not", jsonArray, sjson);
            } else {
                this.add("not", schema.not(), sjson);
            }
            if (schema.oneOfRef().length > 0) {
                jsonArray = new JSONArray();
                for (String ref : schema.oneOfRef()) {
                    jsonArray.put((Object)new JSONObject().put("$ref", (Object)ref));
                }
                this.add("oneOf", jsonArray, sjson);
            } else {
                this.add("oneOf", schema.oneOf(), sjson);
            }
            if (schema.anyOfRef().length > 0) {
                jsonArray = new JSONArray();
                for (String ref : schema.anyOfRef()) {
                    jsonArray.put((Object)new JSONObject().put("$ref", (Object)ref));
                }
                this.add("anyOf", jsonArray, sjson);
            } else {
                this.add("anyOf", schema.anyOf(), sjson);
            }
            if (schema.allOfRef().length > 0) {
                jsonArray = new JSONArray();
                for (String ref : schema.allOfRef()) {
                    jsonArray.put((Object)new JSONObject().put("$ref", (Object)ref));
                }
                this.add("allOf", jsonArray, sjson);
            } else {
                this.add("allOf", schema.oneOf(), sjson);
            }
            this.add("title", schema.title(), sjson);
            this.add("description", schema.description(), sjson);
            this.add("multipleOf", schema.multipleOf(), sjson, 0.0);
            this.add("exclusiveMaximum", schema.exclusiveMaximum(), sjson, (Boolean)false);
            this.add("exclusiveMaximum", schema.exclusiveMaximum(), sjson, (Boolean)false);
            this.add("maxLength", schema.maxLength(), sjson, Integer.MAX_VALUE);
            this.add("minLength", schema.minLength(), sjson, 0);
            try {
                if (schema.minimum().length() > 0) {
                    this.add("minimum", Integer.parseInt(schema.minimum()), sjson, 0);
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            try {
                if (schema.maximum().length() > 0) {
                    this.add("maximum", Integer.parseInt(schema.maximum()), sjson, 0);
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            this.add("pattern", schema.pattern(), sjson);
            this.add("maxProperties", schema.maxProperties(), sjson, 0);
            this.add("minProperties", schema.minProperties(), sjson, 0);
            this.add("requiredProperties", schema.requiredProperties(), sjson);
            this.add("description", schema.description(), sjson);
            this.add("format", schema.format(), sjson);
            this.add("nullable", schema.nullable(), sjson, (Boolean)false);
            this.add("deprecated", schema.deprecated(), sjson, (Boolean)false);
            this.add("default", schema.defaultValue(), sjson);
            if (schema.allowableValues().length > 1) {
                this.add("enum", schema.allowableValues(), sjson);
            } else if (schema.allowableValues().length == 1) {
                this.add("const", schema.allowableValues()[0], sjson);
            }
            this.add("externalDocs", schema.externalDocs(), sjson);
            this.add("discriminatorProperty", schema.discriminatorProperty(), sjson);
            this.add("DiscriminatorMapping", schema.discriminatorMapping(), sjson);
            this.add("additionalProperties", schema.additionalProperties(), sjson, true);
            this.add("subTypes", schema.subTypes(), sjson);
            JSONArray ex = new JSONArray();
            for (Map.Entry entry : this.extractExamples(schema).entrySet()) {
                this.examples.add(new Example((String)entry.getKey(), sjson, schema.type()));
            }
            if (ex.length() > 0) {
                this.add("examples", ex, sjson);
            }
        }
        return sjson;
    }

    public HashMap<String, String> extractExamples(Parameter parameter) {
        HashMap<String, String> exx = this.extractExamples(parameter.schema());
        for (ExampleObject e : parameter.examples()) {
            exx.put(e.value(), e.name());
        }
        if (parameter.example().length() > 0) {
            exx.put(parameter.example(), "");
        }
        return exx;
    }

    public HashMap<String, String> extractExamples(de.kosmos_lab.web.annotations.media.Schema schema) {
        HashMap<String, String> exx = this.extractExamples(schema.example(), schema.examples());
        return exx;
    }

    public HashMap<String, String> extractExamples(String example, ExampleObject[] examples) {
        HashMap<String, String> exx = new HashMap<String, String>();
        if (example != null && example.length() > 0) {
            exx.put(example, "");
        }
        for (ExampleObject e : examples) {
            if (e.value().length() <= 0) continue;
            exx.put(e.value(), e.name());
        }
        return exx;
    }

    public void add(String tag, de.kosmos_lab.web.annotations.media.Schema schema, JSONObject json) {
        JSONObject sjson = this.toJSON(schema);
        if (sjson.length() > 0) {
            json.put(tag, (Object)sjson);
        }
    }

    public void add(String tag, DiscriminatorMapping[] value, JSONObject json) {
        if (value.length > 0) {
            // empty if block
        }
    }

    public void add(String tag, ExternalDocumentation value, JSONObject json) {
        JSONObject j = new JSONObject();
        if (value.url().length() > 0) {
            j.put("url", (Object)value.url());
            json.put(tag, (Object)j);
        }
        if (value.description().length() > 0) {
            j.put("description", (Object)value.description());
            json.put(tag, (Object)j);
        }
    }

    public void add(String tag, double value, JSONObject json, Double ignoreIfThis) {
        if (ignoreIfThis == null || ignoreIfThis != value) {
            json.put(tag, value);
        }
    }

    public void add(String tag, Class<?>[] clzlist, JSONObject json) {
        JSONArray arr = new JSONArray();
        for (Class<?> clz : clzlist) {
            if (clz == Void.class) continue;
            arr.put((Object)clz.getName());
        }
        if (arr.length() > 0) {
            json.put(tag, (Object)arr);
        }
    }

    public void add(String tag, Class<?> clz, JSONObject json) {
        if (clz != Void.class) {
            json.put(tag, (Object)clz.getName());
        }
    }

    public void add(String tag, boolean value, JSONObject json, Boolean ignoreIfThis) {
        if (ignoreIfThis == null || ignoreIfThis != value) {
            json.put(tag, value);
        }
    }

    public void add(String tag, int value, JSONObject json, Integer ignoreIfThis) {
        if (ignoreIfThis == null || ignoreIfThis != value) {
            json.put(tag, value);
        }
    }

    public void add(String tag, JSONObject values, JSONObject json) {
        if (values != null && values.length() > 0) {
            json.put(tag, (Object)values);
        }
    }

    public void add(String tag, JSONArray values, JSONObject json) {
        if (values != null && values.length() > 0) {
            json.put(tag, (Object)values);
        }
    }

    public String getStringFromResource(String name) {
        String v;
        if (this.labels == null) {
            Locale locale = new Locale("en", "US");
            this.labels = ResourceBundle.getBundle("translation", locale);
        }
        if ((v = this.labels.getString(name)) != null) {
            return v;
        }
        this.missingFromResource.add(name);
        return name;
    }

    public String prepareString(String input) {
        Matcher m = this.formatPattern.matcher(input);
        while (m.matches()) {
            if (m.groupCount() >= 2) {
                input = input.replaceFirst("%\\{(?<key>.*?)\\}", this.getStringFromResource(m.group("key")));
            }
            m = this.formatPattern.matcher(input);
        }
        return input.replace("\n", "  \n");
    }

    public void add(String tag, String value, JSONObject json) {
        if (value != null && value.length() > 0) {
            json.put(tag, (Object)this.prepareString(value));
        }
    }

    public Object parseValue(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.startsWith("{")) {
            try {
                return new JSONObject(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value.startsWith("[")) {
            try {
                return new JSONArray(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public void add(String tag, String value, JSONObject json, boolean parseValue) {
        if (value != null && value.length() > 0) {
            if (parseValue) {
                json.put(tag, this.parseValue(value));
            }
            json.put(tag, (Object)this.prepareString(value));
        }
    }

    public void add(String tag, String[] values, JSONObject json) {
        if (values != null && values.length > 0) {
            JSONArray arr = new JSONArray();
            for (String v : values) {
                arr.put((Object)v);
            }
            json.put(tag, (Object)arr);
        }
    }
}

