/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server;

import de.kosmos_lab.utils.FileUtils;
import de.kosmos_lab.utils.StringFunctions;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ApiResponseDescription;
import de.kosmos_lab.web.doc.openapi.WebSocketEndpoint;
import de.kosmos_lab.web.server.WebSocketCreator;
import de.kosmos_lab.web.server.WebSocketService;
import de.kosmos_lab.web.server.servlets.BaseServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.websocket.server.ServerEndpoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.json.JSONException;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebServer {
    public static final Logger logger = LoggerFactory.getLogger((String)"WebServer");
    public static final int STATUS_OK = 200;
    public static final int STATUS_NO_RESPONSE = 204;
    @ApiResponseDescription(name="NoAccessError", description="The request was aborted because your user does not have the correct privileges to execute the request.")
    public static final int STATUS_FORBIDDEN = 403;
    @ApiResponseDescription(name="ValidationFailedError", description="The request was aborted because the payload could not be verified against the schema.  \nSee errormessage for details")
    public static final int STATUS_VALIDATION_FAILED = 400;
    @ApiResponseDescription(name="DuplicateError", description="The request was aborted because there was already a resource with that identifier.  \nSee errormessage for details")
    public static final int STATUS_DUPLICATE = 409;
    @ApiResponseDescription(name="FailedError", description="The request was aborted.  \nSee errormessage for details ")
    public static final int STATUS_FAILED = 400;
    @ApiResponseDescription(name="NoAuthError", description="This endpoint only works with authentication")
    public static final int STATUS_NO_AUTH = 401;
    @ApiResponseDescription(name="NotFoundError", description="The searched resource was not found  \nSee errormessage for details")
    public static final int STATUS_NOT_FOUND = 404;
    @ApiResponseDescription(name="ConflictError", description="The request was aborted because there was already a resource with that identifier.  \nSee errormessage for details")
    public static final int STATUS_CONFLICT = 409;
    @ApiResponseDescription(name="UnproccessableError", description="The request could not be processed, are all required properties/parameters filled?  \nSee errormessage for details")
    public static final int STATUS_UNPROCESSABLE = 422;
    @ApiResponseDescription(name="MissingValuesError", description="The request could not be processed, are all required properties/parameters filled?  \nSee errormessage for details")
    public static final int STATUS_MISSING_VALUE = 422;
    @ApiResponseDescription(name="UnknownError", description="The server ran into an error while processing the request")
    public static final int STATUS_ERROR = 500;
    @ApiResponseDescription(name="MethodNotAllowedError", description="The requested HTTP-method is not valid for this endpoint")
    public static final int STATUS_METHOD_NOT_ALLOWED = 405;
    protected static final int DEFAULT_PORT = 8101;
    protected static final String DEFAULT_CONFIG = "config/config.json";
    protected Server server;
    protected int port;
    protected Set<Class<? extends HttpServlet>> servlets = new HashSet<Class<? extends HttpServlet>>();
    protected Set<Class<? extends WebSocketService>> wsservices = new HashSet<Class<? extends WebSocketService>>();
    protected HashSet<String> wssclasses = new HashSet();
    protected HashSet<String> servclasses = new HashSet();
    protected HashSet<String> paths = new HashSet();
    protected HashSet<String> wsPaths = new HashSet();
    protected ContextHandlerCollection handlers;
    protected ServletContextHandler context;
    protected HashSet<Class<? extends HttpServlet>> loadedServlets = new HashSet();
    protected boolean stopped = false;
    HashSet<Class<? extends Exception>> thrown = new HashSet();
    private File configFile;

    public WebServer(File configFile, boolean testing) throws Exception {
        if (configFile == null) {
            configFile = new File(this.getDefaultConfig());
        }
        this.configFile = configFile;
        this.prepare();
        this.start();
    }

    public WebServer() {
    }

    public abstract HttpServlet create(Class<? extends HttpServlet> var1, ApiEndpoint var2) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    public abstract WebSocketService create(Class<? extends WebSocketService> var1, WebSocketEndpoint var2) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    public void createServlet(Class<? extends HttpServlet> servlet) {
        ApiEndpoint api = servlet.getAnnotation(ApiEndpoint.class);
        if (api != null) {
            try {
                if (this.paths.contains(api.path())) {
                    logger.warn("did find path {} again?", (Object)api.path());
                    return;
                }
                HttpServlet s = this.create(servlet, api);
                this.context.addServlet(new ServletHolder((Servlet)s), api.path());
                this.loadedServlets.add(servlet);
                this.paths.add(api.path());
                logger.info("registered web servlet {} ", s.getClass());
                return;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void addStaticFile(File f, String name) {
        ServletHolder staticFiles = new ServletHolder("default", (Servlet)new DefaultServlet());
        staticFiles.setInitParameter("resourceBase", "./web/");
        this.context.addServlet(staticFiles, "/*");
    }

    public void start() throws Exception {
        for (Class<? extends HttpServlet> clazz : this.servlets) {
            this.createServlet(clazz);
        }
        for (Class<Object> clazz : this.wsservices) {
            this.createWebSocketService(clazz);
        }
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)this.context, null);
        this.handlers.addHandler((Handler)this.context);
        this.server.setHandler((Handler)this.handlers);
        this.loadResources();
        this.server.start();
    }

    public void createWebSocketService(Class<? extends WebSocketService> c) {
        ServerEndpoint serverEndpoint;
        WebSocketEndpoint endpoint = c.getAnnotation(WebSocketEndpoint.class);
        if (endpoint != null && !this.wsPaths.contains(endpoint.path())) {
            logger.info("found: WebSocketService: {} endpoint {}", (Object)c.getName(), (Object)endpoint.path());
            try {
                final WebSocketService service = this.create(c, endpoint);
                JettyWebSocketServlet websocketServlet = new JettyWebSocketServlet(){

                    protected void configure(JettyWebSocketServletFactory factory) {
                        factory.setIdleTimeout(Duration.ofSeconds(60L));
                        factory.setCreator((JettyWebSocketCreator)new WebSocketCreator(service, null));
                    }
                };
                this.context.addServlet(new ServletHolder((Servlet)websocketServlet), endpoint.path());
                this.wsPaths.add(endpoint.path());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if ((serverEndpoint = c.getAnnotation(ServerEndpoint.class)) != null && !this.wsPaths.contains(serverEndpoint.value())) {
            logger.info("found: WebSocketService: {} endpoint {}", (Object)c.getName(), (Object)serverEndpoint.value());
            try {
                final WebSocketService service = c.getConstructor(WebServer.class).newInstance(this);
                JettyWebSocketServlet websocketServlet = new JettyWebSocketServlet(){

                    protected void configure(JettyWebSocketServletFactory factory) {
                        factory.setIdleTimeout(Duration.ofSeconds(60L));
                        factory.setCreator((JettyWebSocketCreator)new WebSocketCreator(service, null));
                    }
                };
                this.context.addServlet(new ServletHolder((Servlet)websocketServlet), serverEndpoint.value());
                this.wsPaths.add(serverEndpoint.value());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    public abstract JSONObject getConfig();

    public void findServlets(String[] namespaces, Class<? extends HttpServlet> baseServletClass, Class<? extends WebSocketService> baseSocketClass) {
        for (String n : namespaces) {
            Reflections r = new Reflections(n, new Scanner[0]);
            if (baseServletClass != null) {
                try {
                    for (Class c : r.getSubTypesOf(Exception.class)) {
                        if (this.thrown.contains(c) || c.getAnnotation(ApiResponse.class) == null) continue;
                        logger.info("Reflections found Exception: {}", (Object)c.getName());
                        this.thrown.add(c);
                    }
                }
                catch (ReflectionsException reflectionsException) {
                    // empty catch block
                }
                try {
                    for (Class c : r.getSubTypesOf(baseServletClass)) {
                        if (this.servlets.contains(c) || this.servclasses.contains(c.getName())) continue;
                        ApiEndpoint endpoint = c.getAnnotation(ApiEndpoint.class);
                        if (endpoint != null) {
                            this.servclasses.add(c.getName());
                            if (endpoint.load()) {
                                logger.info("Reflections found HttpServlet: {}", (Object)c.getName());
                                this.servlets.add(c);
                                continue;
                            }
                            logger.info("Reflections found HttpServlet, but it is marked with load=false {}", (Object)c.getName());
                            continue;
                        }
                        logger.warn("Reflections found HttpServlet, but it had no @ApiEndpoint annotation!: {}", (Object)c.getName());
                    }
                }
                catch (ReflectionsException reflectionsException) {
                    // empty catch block
                }
                for (Class annotation : new Class[]{ApiEndpoint.class}) {
                    try {
                        for (Class c : r.getTypesAnnotatedWith(annotation)) {
                            if (!baseServletClass.isAssignableFrom(c) || this.servlets.contains(c) || this.servclasses.contains(c.getName())) continue;
                            if (annotation == ApiEndpoint.class) {
                                ApiEndpoint endpoint = c.getAnnotation(ApiEndpoint.class);
                                if (endpoint == null) continue;
                                if (endpoint.load()) {
                                    logger.info("Reflections found HttpServlet: {}", (Object)c.getName());
                                    this.servlets.add(c);
                                    continue;
                                }
                                logger.info("Reflections found HttpServlet, but it is marked with load=false {}", (Object)c.getName());
                                continue;
                            }
                            this.servclasses.add(c.getName());
                            logger.info("Annotations ({}) found HttpServlet: {}", (Object)annotation.getName(), (Object)c.getName());
                            this.servlets.add(c);
                        }
                    }
                    catch (ReflectionsException reflectionsException) {
                        // empty catch block
                    }
                }
            }
            if (baseSocketClass == null) continue;
            try {
                for (Class c : r.getSubTypesOf(baseSocketClass)) {
                    if (this.wsservices.contains(c) || this.wssclasses.contains(c.getName())) continue;
                    this.wssclasses.add(c.getName());
                    logger.info("Reflections found WebSocketService: {}", (Object)c.getName());
                    this.wsservices.add(c);
                }
            }
            catch (ReflectionsException reflectionsException) {
                // empty catch block
            }
            for (Class annotation : new Class[]{ServerEndpoint.class}) {
                try {
                    for (Class c : r.getTypesAnnotatedWith(annotation)) {
                        if (!baseSocketClass.isAssignableFrom(c) || this.wsservices.contains(c) || this.wssclasses.contains(c.getName())) continue;
                        this.wssclasses.add(c.getName());
                        logger.info("Annotations ({}) found WebSocketService: {}", (Object)annotation.getName(), (Object)c.getName());
                        this.wsservices.add(c);
                    }
                }
                catch (ReflectionsException reflectionsException) {
                    // empty catch block
                }
            }
            try {
                for (Class c : r.getTypesAnnotatedWith(WebSocketEndpoint.class)) {
                    WebSocketEndpoint endpoint;
                    if (!baseSocketClass.isAssignableFrom(c) || this.wsservices.contains(c) || this.wssclasses.contains(c.getName()) || (endpoint = c.getAnnotation(WebSocketEndpoint.class)) == null || !endpoint.load()) continue;
                    this.wssclasses.add(c.getName());
                    logger.info("Annotations ({}) found WebSocketService: {}", (Object)WebSocketEndpoint.class.getName(), (Object)c.getName());
                    this.wsservices.add(c);
                }
            }
            catch (ReflectionsException reflectionsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject readConfig() {
        JSONObject config = null;
        if (this.configFile == null) {
            logger.error("CONFIG FILE IS NULL!");
            throw new RuntimeException("CONFIG FILE IS NULL!");
        }
        if (!this.configFile.exists()) {
            if (!this.configFile.getParentFile().exists() && !this.configFile.getParentFile().mkdirs()) {
                logger.error("COULD NOT CREATE PARENT DIRS:{}", (Object)this.configFile.getParentFile());
                throw new RuntimeException("COULD NOT CREATE PARENT DIRS:" + this.configFile.getParentFile());
            }
            File distFile = new File(this.configFile.getAbsolutePath() + ".dist");
            if (distFile.exists()) {
                try {
                    Files.copy(distFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.configFile.exists()) {
            try {
                config = new JSONObject(FileUtils.readFile((File)this.configFile));
            }
            catch (IOException | JSONException distFile) {
                // empty catch block
            }
        }
        if (config == null) {
            config = new JSONObject();
        }
        int myPort = this.getDefaultPort();
        try {
            myPort = config.getInt("port");
        }
        catch (Exception e) {
            config.put("port", this.getDefaultPort());
        }
        finally {
            this.port = myPort;
        }
        String temp = config.optString("pepper", null);
        temp = config.optString("jwt", null);
        if (temp == null) {
            temp = StringFunctions.generateRandomKey();
            config.put("jwt", (Object)temp);
        }
        if ((temp = config.optString("jwt", null)) == null) {
            temp = StringFunctions.generateRandomKey();
            config.put("jwt", (Object)temp);
        }
        return config;
    }

    public String getDefaultConfig() {
        return DEFAULT_CONFIG;
    }

    public int getDefaultPort() {
        return 8101;
    }

    public int getPort() {
        return this.port;
    }

    public void prepare() {
        ServletContextHandler servletContextHandler;
        this.findServlets(new String[]{"de.kosmos_lab.web.server.servlets.openapi"}, BaseServlet.class, null);
        int maxThreads = 10;
        int minThreads = 2;
        int idleTimeout = 120;
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads, minThreads, idleTimeout);
        JSONObject webserverConfig = this.getConfig();
        this.server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(this.server);
        this.port = webserverConfig.getInt("port");
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        this.handlers = new ContextHandlerCollection();
        this.context = servletContextHandler = new ServletContextHandler();
        this.context.setContextPath("/");
        ServletHolder staticFiles = new ServletHolder("default", (Servlet)new DefaultServlet());
        staticFiles.setInitParameter("resourceBase", "./web/");
        staticFiles.setInitParameter("dirAllowed", "false");
        this.context.addServlet(staticFiles, "/*");
    }

    public void stop() {
        try {
            this.stopped = true;
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    protected Set<Class<? extends WebSocketService>> getWebSocketServices() {
        return this.wsservices;
    }

    public void loadResources() {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        for (Class<? extends HttpServlet> servlet : this.servlets) {
            ClassLoader loader = servlet.getClassLoader();
            if (classLoaders.contains(loader)) continue;
            classLoaders.add(loader);
            logger.info("found classloader {}", (Object)loader.getName());
        }
        for (ClassLoader loader : classLoaders) {
            try {
                for (String f : this.getResourceFiles(loader, "web")) {
                    logger.info("found resource file {}", (Object)f);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<String> getResourceFiles(ClassLoader loader, String path) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        try (InputStream in = this.getResourceAsStream(loader, path);
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String resource;
            while ((resource = br.readLine()) != null) {
                filenames.add(resource);
            }
        }
        return filenames;
    }

    private List<String> getResourceFiles(String path) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        try (InputStream in = this.getResourceAsStream(path);
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String resource;
            while ((resource = br.readLine()) != null) {
                filenames.add(resource);
            }
        }
        return filenames;
    }

    private InputStream getResourceAsStream(ClassLoader loader, String resource) {
        InputStream in = loader.getResourceAsStream(resource);
        return in == null ? this.getClass().getResourceAsStream(resource) : in;
    }

    private InputStream getResourceAsStream(String resource) {
        InputStream in = this.getContextClassLoader().getResourceAsStream(resource);
        return in == null ? this.getClass().getResourceAsStream(resource) : in;
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public String replaceHostName(String cached, String hostname) {
        return cached.replace("${host}", hostname);
    }
}

