/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWT {
    public static final long DEFAULT_LIFETIME = 3600000L;
    Algorithm algorithm;
    private static final Logger logger = LoggerFactory.getLogger((String)"JWT");
    public final long lifetime;
    protected byte[] key;

    public static String trim(String data) {
        while (data.endsWith("=")) {
            data = data.substring(0, data.length() - 1);
        }
        return data;
    }

    public JWT(String key, long lifetime) {
        this(Algorithm.HS256, key, lifetime);
    }

    public JWT(String key) {
        this(Algorithm.HS256, key, 3600000L);
    }

    public JWT(Algorithm algorithm, String key, long lifetime) {
        this.lifetime = lifetime;
        this.algorithm = algorithm;
        this.key = key.getBytes(StandardCharsets.UTF_8);
    }

    public String encode(String data) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        if (this.algorithm == Algorithm.HS256) {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(this.key, "HmacSHA256");
            sha256_HMAC.init(secret_key);
            return Base64.getUrlEncoder().encodeToString(sha256_HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8)));
        }
        if (this.algorithm == Algorithm.NONE) {
            return "";
        }
        throw new NoSuchAlgorithmException(this.algorithm + " is not implemented");
    }

    public String sign(byte[] head, byte[] payload) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        Base64.Encoder b = Base64.getUrlEncoder();
        String s = JWT.trim(b.encodeToString(head)) + "." + JWT.trim(b.encodeToString(payload));
        s = s + "." + JWT.trim(this.encode(s));
        return s;
    }

    public String sign(JSONObject object) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        JSONObject h = new JSONObject();
        h.put("type", (Object)"JWT");
        h.put("alg", (Object)this.algorithm.name());
        object.put("exp", System.currentTimeMillis() + this.lifetime);
        return this.sign(h.toString().getBytes(StandardCharsets.UTF_8), object.toString().getBytes(StandardCharsets.UTF_8));
    }

    public JSONObject verify(String data) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException, JWTVerifyFailed {
        String pl;
        JSONObject obj;
        byte[] payload;
        String[] token = JWT.trim(data).split("\\.");
        if (token.length != 3) {
            throw new JWTVerifyFailed();
        }
        byte[] head = Base64.getUrlDecoder().decode(token[0]);
        String s = this.sign(head, payload = Base64.getUrlDecoder().decode(token[1]));
        if (s.equals(data = data.replace("=", "")) && (obj = new JSONObject(pl = new String(payload, StandardCharsets.US_ASCII))).has("exp") && obj.getLong("exp") > System.currentTimeMillis()) {
            return obj;
        }
        throw new JWTVerifyFailed();
    }

    public static String extractPayload(String data) throws JWTVerifyFailed {
        String[] token = JWT.trim(data).split("\\.");
        if (token.length != 3) {
            throw new JWTVerifyFailed();
        }
        return new String(Base64.getUrlDecoder().decode(token[1]), StandardCharsets.US_ASCII);
    }

    public static final class JWTVerifyFailed
    extends Exception {
        private static final long serialVersionUID = -7577398934097264131L;
    }

    public static enum Algorithm {
        NONE,
        HS256;

    }
}

