/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.data;

import de.kosmos_lab.utils.StringFunctions;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.persistence.ControllerWithPersistence;
import de.kosmos_lab.web.persistence.JSONPersistence;
import de.kosmos_lab.web.persistence.JSONPersistenceObject;
import java.util.UUID;
import org.json.JSONObject;

public class User
implements JSONPersistenceObject,
IUser {
    private static final String FIELD_UUID = "UUID";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_LEVEL = "level";
    private static final String FIELD_SALT = "salt";
    private static final String FIELD_HASH = "hash";
    private final ControllerWithPersistence server;
    private final UUID uuid;
    private final String salt;
    private final String hash;
    private int level = 0;
    private final String name;

    public User(ControllerWithPersistence server, String uuid, String username, String hash, String salt, int userLevel) {
        this(server, UUID.fromString(uuid), username, hash, salt, userLevel);
    }

    public User(ControllerWithPersistence server, UUID uuid, String username, String hash, String salt, int userLevel) {
        if (uuid == null) {
            uuid = server.generateUUID();
        }
        this.server = server;
        this.salt = salt;
        this.name = username;
        this.level = userLevel;
        this.uuid = uuid;
        this.hash = hash;
    }

    public User(JSONPersistence persistence, JSONObject jsonObject) {
        this(persistence.getController(), jsonObject.optString(FIELD_UUID), jsonObject.getString(FIELD_NAME), jsonObject.getString(FIELD_HASH), jsonObject.getString(FIELD_SALT), jsonObject.getInt(FIELD_LEVEL));
    }

    @Override
    public boolean canAccess(int level) {
        return this.level >= level;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public boolean isAdmin() {
        return this.level >= 100;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put(FIELD_NAME, (Object)this.name);
        o.put(FIELD_LEVEL, this.level);
        o.put(FIELD_UUID, (Object)this.uuid.toString());
        o.put(FIELD_SALT, (Object)this.salt);
        o.put(FIELD_HASH, (Object)this.hash);
        return o;
    }

    @Override
    public JSONObject toJWT() {
        JSONObject o = new JSONObject();
        o.put(FIELD_NAME, (Object)this.name);
        o.put(FIELD_LEVEL, this.level);
        o.put("id", (Object)this.uuid.toString());
        String jwtid = StringFunctions.generateRandomKey();
        while (this.server.isKnownJWTID(jwtid)) {
            jwtid = StringFunctions.generateRandomKey();
        }
        o.put("jwtid", (Object)jwtid);
        return o;
    }

    @Override
    public boolean checkPassword(String password) {
        return this.server.hashSaltPepper(password, this.salt).equals(this.hash);
    }
}

