/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server.servlets.session;

import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.persistence.ISesssionPersistence;
import de.kosmos_lab.web.persistence.exceptions.NoPersistenceException;
import de.kosmos_lab.web.server.ExampleWebServer;
import de.kosmos_lab.web.server.servlets.AuthedServlet;
import de.kosmos_lab.web.server.servlets.MyHttpServletRequest;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONObject;

@WebServlet(urlPatterns={"/session/kill"}, loadOnStartup=1)
public class KillServlet
extends AuthedServlet {
    public KillServlet(ExampleWebServer webServer) {
        super(webServer, 1);
    }

    @Override
    public void post(MyHttpServletRequest request, HttpServletResponse response) throws IOException, ParameterNotFoundException, NoPersistenceException {
        String jwtid = request.getParameter("id", true);
        JSONObject jwt = this.server.getPersistence(ISesssionPersistence.class).getJWT(jwtid);
        if (request.getUser().getName().equals(jwt.getString("name"))) {
            this.server.getPersistence(ISesssionPersistence.class).killJWT(jwtid);
            response.setStatus(204);
            return;
        }
        if (request.getUser().isAdmin() && request.getUser().getLevel() > jwt.getInt("level")) {
            this.server.getPersistence(ISesssionPersistence.class).killJWT(jwtid);
            response.setStatus(204);
            return;
        }
        response.setStatus(403);
    }
}

