/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server;

import ch.qos.logback.classic.Level;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import de.kosmos_lab.web.annotations.ExternalDocumentation;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.Explode;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.headers.Header;
import de.kosmos_lab.web.annotations.info.Contact;
import de.kosmos_lab.web.annotations.info.Info;
import de.kosmos_lab.web.annotations.info.License;
import de.kosmos_lab.web.annotations.media.ArraySchema;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.DiscriminatorMapping;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.ObjectSchema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.annotations.security.OAuthFlow;
import de.kosmos_lab.web.annotations.security.OAuthFlows;
import de.kosmos_lab.web.annotations.security.Scope;
import de.kosmos_lab.web.annotations.security.SecurityRequirement;
import de.kosmos_lab.web.annotations.security.SecuritySchema;
import de.kosmos_lab.web.annotations.servers.Server;
import de.kosmos_lab.web.annotations.tags.Tag;
import de.kosmos_lab.web.data.Tuple;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ApiResponseDescription;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.server.Example;
import de.kosmos_lab.web.server.WebServer;
import jakarta.servlet.http.HttpServlet;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiParser {
    public static final HashSet<String> missingFromResource = new HashSet();
    protected static final Logger logger = LoggerFactory.getLogger((String)"OpenApiParser");
    private static final String formatRegex = "%\\{(?<key>.*?)\\}";
    private static final Pattern formatPattern = Pattern.compile(".*?(%\\{(?<key>.*?)\\}).*+");
    public static Class<? extends WebServer> serverClass = WebServer.class;
    static HashSet<Class<? extends HttpServlet>> servlets = new HashSet();
    private static JSONObject json = null;
    private static HashSet<de.kosmos_lab.web.annotations.media.Schema> schemas = new HashSet();
    private static HashSet<ObjectSchema> oschemas = new HashSet();
    private static HashSet<ArraySchema> aschemas = new HashSet();
    private static HashSet<Parameter> parameters = new HashSet();
    private static HashSet<Tag> tags = new HashSet();
    private static ResourceBundle labels = null;
    private static HashMap<String, JSONObject> mResponses = new HashMap();
    private static JSONObject components;
    private static LinkedList<Example> examples;
    private static JSONObject responses;

    public static String asYaml(String jsonString) throws JsonProcessingException, IOException {
        JsonNode jsonNodeTree = new ObjectMapper().readTree(jsonString);
        String jsonAsYaml = new YAMLMapper().writeValueAsString((Object)jsonNodeTree);
        return jsonAsYaml;
    }

    public static String getYAML() throws IOException {
        return OpenApiParser.asYaml(OpenApiParser.getJSON().toString());
    }

    public static void create(HashSet<Class<? extends HttpServlet>> pservlets) {
        if (servlets == null) {
            servlets = pservlets;
        } else {
            for (Class<? extends HttpServlet> servlet : pservlets) {
                servlets.add(servlet);
            }
        }
    }

    public static JSONObject toJSON(Info info) {
        JSONObject jinfo = new JSONObject();
        OpenApiParser.add("description", info.description(), jinfo);
        OpenApiParser.add("contact", info.contact(), jinfo);
        OpenApiParser.add("termsOfService", info.termsOfService(), jinfo);
        OpenApiParser.add("title", info.title(), jinfo);
        OpenApiParser.add("version", info.version(), jinfo);
        OpenApiParser.add("license", info.license(), jinfo);
        return jinfo;
    }

    public static void add(String tag, License license, JSONObject json) {
        JSONObject licenseJSON = new JSONObject();
        OpenApiParser.add("url", license.url(), licenseJSON);
        OpenApiParser.add("name", license.name(), licenseJSON);
        OpenApiParser.add(tag, licenseJSON, json);
    }

    public static void add(String tag, Contact contact, JSONObject json) {
        JSONObject contactJSON = new JSONObject();
        OpenApiParser.add("email", contact.email(), contactJSON);
        OpenApiParser.add("url", contact.url(), contactJSON);
        OpenApiParser.add("name", contact.name(), contactJSON);
        OpenApiParser.add(tag, contactJSON, json);
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject getJSON() {
        void var7_23;
        String name;
        if (json != null) {
            return json;
        }
        json = new JSONObject();
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.reflections")).setLevel(Level.OFF);
        Reflections r = new Reflections("", new Scanner[0]);
        OpenApiParser.add("openapi", "3.0.0", json);
        JSONObject info = new JSONObject();
        Info infoAnnotation = serverClass.getAnnotation(Info.class);
        if (infoAnnotation != null) {
            info = OpenApiParser.toJSON(infoAnnotation);
        }
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            de.kosmos_lab.web.annotations.media.Schema[] model = reader.read((Reader)new FileReader("pom.xml"));
            info.put("version", (Object)model.getVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        OpenApiParser.add("info", info, json);
        components = new JSONObject();
        JSONObject securitySchemes = new JSONObject();
        for (de.kosmos_lab.web.annotations.media.Schema schema : (de.kosmos_lab.web.annotations.media.Schema[])serverClass.getAnnotationsByType(de.kosmos_lab.web.annotations.media.Schema.class)) {
            name = schema.name();
            if (name.length() <= 0) continue;
            schemas.add(schema);
        }
        for (Annotation annotation : (ObjectSchema[])serverClass.getAnnotationsByType(ObjectSchema.class)) {
            name = annotation.componentName();
            if (name.length() <= 0) continue;
            oschemas.add((ObjectSchema)annotation);
        }
        for (Annotation annotation : (SecuritySchema[])serverClass.getAnnotationsByType(SecuritySchema.class)) {
            name = annotation.componentName();
            if (name.length() == 0) {
                name = annotation.name();
            }
            if (name.length() <= 0) continue;
            JSONObject jSONObject = new JSONObject();
            OpenApiParser.add("name", annotation.name(), jSONObject);
            OpenApiParser.add("description", annotation.description(), jSONObject);
            OpenApiParser.add("scheme", annotation.scheme(), jSONObject);
            OpenApiParser.add("openIdConnectUrl", annotation.openIdConnectUrl(), jSONObject);
            OpenApiParser.add("bearerFormat", annotation.bearerFormat(), jSONObject);
            OpenApiParser.add("type", annotation.type().toString(), jSONObject);
            OpenApiParser.add("in", annotation.in().toString(), jSONObject);
            OpenApiParser.add("flows", annotation.flows(), jSONObject);
            OpenApiParser.add(name, jSONObject, securitySchemes);
        }
        OpenApiParser.add("securitySchemes", securitySchemes, components);
        responses = new JSONObject();
        for (Class c : r.getTypesAnnotatedWith(ApiResponse.class)) {
            for (ApiResponse apiResponse : (ApiResponse[])c.getAnnotationsByType(ApiResponse.class)) {
                if (Exception.class.isAssignableFrom(c)) {
                    responses.put(c.getSimpleName().replace("Exception", "Error"), (Object)OpenApiParser.toJSON(apiResponse));
                }
                if (apiResponse.componentName().length() <= 0) continue;
                responses.put(apiResponse.componentName(), (Object)OpenApiParser.toJSON(apiResponse));
            }
        }
        for (Class c : r.getTypesAnnotatedWith(ApiResponseDescription.class)) {
            for (ApiResponseDescription apiResponseDescription : (ApiResponseDescription[])c.getAnnotationsByType(ApiResponseDescription.class)) {
                if (apiResponseDescription.name().length() <= 0) continue;
                responses.put(apiResponseDescription.name(), (Object)new JSONObject().put("description", (Object)apiResponseDescription.description()));
            }
        }
        JSONArray servers = new JSONArray();
        Server[] c = (Server[])serverClass.getAnnotationsByType(Server.class);
        int n = c.length;
        boolean bl = false;
        while (var7_23 < n) {
            Server s = c[var7_23];
            logger.info("found server {}", (Object)s);
            JSONObject jSONObject = new JSONObject();
            OpenApiParser.add("description", s.description(), jSONObject);
            OpenApiParser.add("url", s.url(), jSONObject);
            servers.put((Object)jSONObject);
            ++var7_23;
        }
        for (Class c2 : r.getTypesAnnotatedWith(Server.class)) {
            for (Server server : (Server[])c2.getAnnotationsByType(Server.class)) {
                logger.info("found server {}", (Object)server);
                JSONObject j = new JSONObject();
                OpenApiParser.add("description", server.description(), j);
                OpenApiParser.add("url", server.url(), j);
                servers.put((Object)j);
            }
        }
        OpenApiParser.add("servers", servers, json);
        OpenApiParser.add("responses", responses, components);
        JSONObject schemajson = new JSONObject();
        JSONObject parametersjson = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject paths = new JSONObject();
        for (Class<? extends HttpServlet> clazz : servlets) {
            ApiEndpoint a = clazz.getAnnotation(ApiEndpoint.class);
            if (a != null && !a.hidden()) {
                logger.info("found {}", (Object)a);
                for (Method method : clazz.getDeclaredMethods()) {
                    for (String method2 : new String[]{"get", "post", "delete"}) {
                        try {
                            Operation am;
                            if (!method.getName().equals(method2) || (am = method.getAnnotation(Operation.class)) == null) continue;
                            OpenApiParser.add(a, am, method, paths);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            OpenApiParser.add("paths", paths, json);
            for (ObjectSchema objectSchema : (ObjectSchema[])clazz.getAnnotationsByType(ObjectSchema.class)) {
                oschemas.add(objectSchema);
            }
            for (ArraySchema arraySchema : (ArraySchema[])clazz.getAnnotationsByType(ArraySchema.class)) {
                aschemas.add(arraySchema);
            }
            for (de.kosmos_lab.web.annotations.media.Schema schema : (de.kosmos_lab.web.annotations.media.Schema[])clazz.getAnnotationsByType(de.kosmos_lab.web.annotations.media.Schema.class)) {
                schemas.add(schema);
            }
            for (Parameter parameter : (Parameter[])clazz.getAnnotationsByType(Parameter.class)) {
                parameters.add(parameter);
            }
            for (Tag tag : (Tag[])clazz.getAnnotationsByType(Tag.class)) {
                tags.add(tag);
            }
        }
        for (ArraySchema arraySchema : aschemas) {
            OpenApiParser.add(arraySchema.name(), OpenApiParser.toJSON(arraySchema), schemajson);
        }
        for (ObjectSchema objectSchema : oschemas) {
            OpenApiParser.add(objectSchema.componentName(), OpenApiParser.toJSON(objectSchema.properties()), schemajson);
        }
        for (de.kosmos_lab.web.annotations.media.Schema schema : schemas) {
            OpenApiParser.add(schema.name(), schema, schemajson);
        }
        for (Parameter parameter : parameters) {
            String name2 = parameter.componentName();
            if (name2.length() == 0) {
                name2 = parameter.name();
            }
            if (name2.length() <= 0) continue;
            OpenApiParser.add(name2, OpenApiParser.toJSON(parameter), parametersjson);
        }
        for (Tag tag : tags) {
            OpenApiParser.add(tag, jSONArray);
        }
        OpenApiParser.add("schemas", schemajson, components);
        OpenApiParser.add("tags", jSONArray, json);
        OpenApiParser.add("parameters", parametersjson, components);
        OpenApiParser.add("components", components, json);
        OpenApiParser.checkExamples();
        return json;
    }

    public static Tuple checkExamples() {
        int failed = 0;
        int checked = 0;
        for (Example ex : examples) {
            if (!OpenApiParser.checkExample(ex.value, OpenApiParser.createJSONSchemaFromSchema(ex.schema), ex.type)) {
                logger.error("Example failed! {} {}", (Object)ex.schema, (Object)ex.value);
                ++failed;
            } else {
                logger.info("Example did pass! {} {}", (Object)ex.schema, (Object)ex.value);
            }
            ++checked;
        }
        if (failed > 0) {
            logger.error("Had {} Examples that failed", (Object)failed);
        }
        return new Tuple<Integer, Integer>(checked, failed);
    }

    public static void add(String tag, OAuthFlows flows, JSONObject json) {
        JSONObject flowsJSON = new JSONObject();
        OpenApiParser.add("implicit", flows.implicit(), flowsJSON);
        OpenApiParser.add("password", flows.password(), flowsJSON);
        OpenApiParser.add("clientCredentials", flows.clientCredentials(), flowsJSON);
        OpenApiParser.add("authorizationCode", flows.authorizationCode(), flowsJSON);
    }

    public static void add(String tag, OAuthFlow flow, JSONObject json) {
        JSONObject flowJSON = new JSONObject();
        OpenApiParser.add("authorizationUrl", flow.authorizationUrl(), flowJSON);
        OpenApiParser.add("tokenUrl", flow.tokenUrl(), flowJSON);
        OpenApiParser.add("refreshUrl", flow.refreshUrl(), flowJSON);
        JSONObject scopesJSON = new JSONObject();
        for (Scope scope : flow.scopes()) {
            scopesJSON.put(scope.name(), (Object)scope.value());
        }
        OpenApiParser.add("scopes", scopesJSON, flowJSON);
        OpenApiParser.add(tag, flowJSON, json);
    }

    public static void add(Tag tag, JSONArray array) {
        JSONObject j = new JSONObject();
        OpenApiParser.add("name", tag.name(), j);
        OpenApiParser.add("description", tag.description(), j);
        OpenApiParser.add("externalDocs", tag.externalDocs(), j);
        if (j.length() > 0) {
            array.put((Object)j);
        }
    }

    public static void add(ApiEndpoint endpoint, Operation operation, Method method, JSONObject paths) {
        JSONArray security;
        JSONObject j;
        block19: {
            block17: {
                block18: {
                    JSONObject epp = paths.optJSONObject(endpoint.path());
                    if (epp == null) {
                        epp = new JSONObject();
                        paths.put(endpoint.path(), (Object)epp);
                    }
                    j = new JSONObject();
                    epp.put(method.getName(), (Object)j);
                    OpenApiParser.add("tags", operation.tags(), j);
                    if (operation.description().length() > 0) {
                        OpenApiParser.add("description", operation.description(), j);
                    } else {
                        OpenApiParser.add("description", operation.summary(), j);
                    }
                    OpenApiParser.add("summary", operation.summary(), j);
                    Object operationId = operation.operationId();
                    if (((String)operationId).length() == 0) {
                        operationId = method.getName() + "-" + endpoint.path().replace("/", "");
                    }
                    OpenApiParser.add("operationId", (String)operationId, j);
                    security = new JSONArray();
                    if (operation.security().length != 0) break block17;
                    if (endpoint.userLevel() < 100) break block18;
                    security.put((Object)new JSONObject().put("bearerAuth", (Object)new JSONArray().put((Object)"admin")));
                    security.put((Object)new JSONObject().put("basicAuth", (Object)new JSONArray().put((Object)"admin")));
                    break block19;
                }
                if (endpoint.userLevel() < 0) break block19;
                security.put((Object)new JSONObject().put("bearerAuth", (Object)new JSONArray().put((Object)"user")));
                security.put((Object)new JSONObject().put("basicAuth", (Object)new JSONArray().put((Object)"user")));
                break block19;
            }
            for (SecurityRequirement s : operation.security()) {
                JSONArray scopes = new JSONArray();
                for (String scope : s.scopes()) {
                    scopes.put((Object)scope);
                }
                security.put((Object)new JSONObject().put(s.name(), (Object)scopes));
            }
        }
        OpenApiParser.add("security", security, j);
        JSONObject resp = new JSONObject();
        if (operation.responses().length > 0) {
            for (ApiResponse response : operation.responses()) {
                JSONObject rjson = OpenApiParser.toJSON(response);
                ResponseCode sc = response.responseCode();
                if (sc.statusCode() != -1) {
                    resp.put(String.valueOf(sc.statusCode()), (Object)rjson);
                    continue;
                }
                resp.put(String.valueOf(sc.status()), (Object)rjson);
            }
        }
        try {
            for (Class<?> ex : method.getExceptionTypes()) {
                String ssc;
                String n = ex.getSimpleName().replace("Exception", "Error");
                ApiResponse apiresp = ex.getAnnotation(ApiResponse.class);
                if (apiresp == null || !responses.has(n)) continue;
                ResponseCode sc = apiresp.responseCode();
                if (sc.statusCode() != -1) {
                    ssc = String.valueOf(sc.statusCode());
                    if (resp.has(ssc)) continue;
                    resp.put(ssc, (Object)new JSONObject().put("$ref", (Object)("#/components/responses/" + n)));
                    continue;
                }
                ssc = String.valueOf(sc.status());
                if (resp.has(ssc)) continue;
                resp.put(ssc, (Object)new JSONObject().put("$ref", (Object)("#/components/responses/" + n)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (endpoint.userLevel() != -1 && !resp.has(String.valueOf(401))) {
            resp.put(String.valueOf(401), (Object)new JSONObject().put("$ref", (Object)"#/components/responses/NoAuthError"));
        }
        j.put("responses", (Object)resp);
        JSONArray params = new JSONArray();
        for (Parameter p : operation.parameters()) {
            OpenApiParser.add(p, params);
        }
        if (params.length() > 0) {
            j.put("parameters", (Object)params);
        }
        JSONObject requestBody = new JSONObject();
        OpenApiParser.add("content", operation.requestBody().content(), requestBody);
        if (requestBody.length() > 0) {
            j.put("requestBody", (Object)requestBody);
        }
    }

    private static JSONObject toJSON(ApiResponse response) {
        JSONObject rjson = new JSONObject();
        OpenApiParser.add("description", response.description(), rjson);
        if (response.ref().length() > 0) {
            JSONObject o = mResponses.get(response.ref());
            if (o != null) {
                return o;
            }
            OpenApiParser.add("$ref", response.ref(), rjson);
        }
        OpenApiParser.add("content", response.content(), rjson);
        OpenApiParser.add("headers", response.headers(), rjson);
        return rjson;
    }

    public static JSONObject toJSON(ArraySchema arraySchema) {
        JSONObject schema = new JSONObject();
        OpenApiParser.add("items", arraySchema.arraySchema(), schema);
        OpenApiParser.add("items", arraySchema.schema(), schema);
        OpenApiParser.add("minItems", arraySchema.minItems(), schema, Integer.MAX_VALUE);
        OpenApiParser.add("maxItems", arraySchema.maxItems(), schema, Integer.MIN_VALUE);
        OpenApiParser.add("uniqueItems", arraySchema.uniqueItems(), schema, (Boolean)false);
        if (schema.length() > 0) {
            OpenApiParser.add("type", "array", schema);
            if (schema.has("items")) {
                schema.getJSONObject("items").remove("description");
            }
            OpenApiParser.add("description", arraySchema.schema().description(), schema);
            OpenApiParser.add("description", arraySchema.arraySchema().description(), schema);
        }
        return schema;
    }

    public static JSONObject createJSONSchemaFromSchema(JSONObject schema) {
        return new JSONObject().put("components", (Object)new JSONObject().put("schemas", (Object)components.optJSONObject("schemas"))).put("$schema", (Object)"http://json-schema.org/draft-07/schema#").put("type", (Object)"object").put("properties", (Object)new JSONObject().put("value", (Object)schema)).put("additionalProperties", false).put("required", (Object)new JSONArray().put((Object)"value"));
    }

    public static boolean checkExample(String value, JSONObject schema, SchemaType type) {
        JSONObject v = null;
        try {
            Schema s = SchemaLoader.load((JSONObject)schema);
            if (type == SchemaType.DEFAULT) {
                if (value.startsWith("{")) {
                    type = SchemaType.OBJECT;
                } else if (value.startsWith("[")) {
                    type = SchemaType.ARRAY;
                }
            }
            switch (type) {
                case STRING: {
                    v = new JSONObject().put("value", (Object)value);
                    s.validate((Object)v);
                    return true;
                }
                case INTEGER: {
                    v = new JSONObject().put("value", Integer.parseInt(value));
                    s.validate((Object)v);
                    return true;
                }
                case NUMBER: {
                    v = new JSONObject().put("value", Double.parseDouble(value));
                    s.validate((Object)v);
                    return true;
                }
                case ARRAY: {
                    v = new JSONObject().put("value", (Object)new JSONArray(value));
                    s.validate((Object)v);
                    return true;
                }
                case BOOLEAN: {
                    v = new JSONObject().put("value", Boolean.parseBoolean(value));
                    s.validate((Object)v);
                    return true;
                }
                case OBJECT: {
                    v = new JSONObject().put("value", (Object)new JSONObject(value));
                    s.validate((Object)v);
                    return true;
                }
            }
            logger.warn("DID NOT TEST {}", (Object)value);
        }
        catch (Exception ex) {
            logger.error("FAILED TO CHECK \nRaw:{}\nValue: {}\n Schema: {}\nReason:{}", new Object[]{value, v, schema, ex.getMessage(), ex});
        }
        return false;
    }

    public static boolean checkExample(ExampleObject e, JSONObject schema, SchemaType type) {
        String value = e.value();
        if (e.value().length() == 0) {
            value = e.name();
        }
        return OpenApiParser.checkExample(value, schema, type);
    }

    public static JSONObject toJSON(Parameter p) {
        JSONObject pjson = new JSONObject();
        if (p.ref().length() > 0) {
            OpenApiParser.add("$ref", p.ref(), pjson);
        } else {
            OpenApiParser.add("description", p.description(), pjson);
            OpenApiParser.add("name", p.name(), pjson);
            JSONObject schema = OpenApiParser.toJSON(p.schema());
            OpenApiParser.add("examples", p.examples(), pjson);
            if (schema.length() > 0) {
                OpenApiParser.add("schema", schema, pjson);
                Object j = null;
                try {
                    if (p.example().length() > 0) {
                        examples.add(new Example(p.example(), schema, p.schema().type()));
                    }
                    if (p.examples().length > 0) {
                        for (ExampleObject e : p.examples()) {
                            String v = e.value();
                            if (v.length() == 0) {
                                v = e.name();
                            }
                            if (v.length() <= 0) continue;
                            examples.add(new Example(v, schema, p.schema().type()));
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("COULD NOT PARSE SCHEMA! {}", j, (Object)e);
                }
            }
            if (p.explode() == Explode.TRUE) {
                OpenApiParser.add("explode", true, pjson, null);
            } else if (p.explode() == Explode.FALSE) {
                OpenApiParser.add("explode", false, pjson, null);
            }
            OpenApiParser.add("example", p.example(), pjson);
            OpenApiParser.add("required", p.required(), pjson, null);
            OpenApiParser.add("deprecated", p.deprecated(), pjson, (Boolean)false);
            OpenApiParser.add("allowEmptyValue", p.allowEmptyValue(), pjson, (Boolean)false);
            OpenApiParser.add("in", p.in().toString(), pjson);
            OpenApiParser.add("style", p.style().toString(), pjson);
            OpenApiParser.add("allowReserved", p.allowReserved(), pjson, (Boolean)false);
            OpenApiParser.add("content", p.content(), pjson);
            OpenApiParser.add("schema", OpenApiParser.toJSON(p.array()), pjson);
            OpenApiParser.add("hidden", p.hidden(), pjson, (Boolean)false);
        }
        return pjson;
    }

    public static void add(Parameter p, JSONArray params) {
        params.put((Object)OpenApiParser.toJSON(p));
    }

    public static JSONObject toJSON(SchemaProperty[] properties) {
        JSONObject schemajson = new JSONObject();
        schemajson.put("type", (Object)"object");
        JSONObject propjson = new JSONObject();
        JSONArray reqarray = new JSONArray();
        for (SchemaProperty sp : properties) {
            OpenApiParser.add(sp.name(), sp.schema(), propjson);
            JSONObject sj = OpenApiParser.toJSON(sp.array());
            if (sj != null) {
                OpenApiParser.add(sp.name(), sj, propjson);
            }
            if (sp.schema().required()) {
                reqarray.put((Object)sp.name());
                continue;
            }
            if (sp.array().schema().required()) {
                reqarray.put((Object)sp.name());
                continue;
            }
            if (!sp.array().arraySchema().required()) continue;
            reqarray.put((Object)sp.name());
        }
        if (propjson.length() > 0) {
            schemajson.put("properties", (Object)propjson);
        }
        if (reqarray.length() > 0) {
            schemajson.put("required", (Object)reqarray);
        }
        return schemajson;
    }

    public static void add(String tag, SchemaProperty[] properties, JSONObject json) {
        json.put(tag, (Object)OpenApiParser.toJSON(properties));
    }

    public static void add(String tag, Content[] value, JSONObject json) {
        if (value.length > 0) {
            JSONObject contentjson = new JSONObject();
            for (Content c : value) {
                if (c.mediaType().length() <= 0) continue;
                JSONObject cjson = new JSONObject();
                OpenApiParser.add("schema", OpenApiParser.toJSON(c.array()), cjson);
                if (!cjson.has("schema")) {
                    if (c.schemaProperties().length > 0) {
                        OpenApiParser.add("schema", c.schemaProperties(), cjson);
                    }
                    if (!cjson.has("schema")) {
                        OpenApiParser.add("schema", OpenApiParser.toJSON(c.schema()), cjson);
                    }
                }
                if (c.examples().length > 0) {
                    OpenApiParser.add("examples", c.examples(), cjson);
                }
                if (cjson.length() > 0) {
                    contentjson.put(c.mediaType(), (Object)cjson);
                }
                Object j = null;
                try {
                    if (c.examples().length <= 0) continue;
                    if (cjson.has("schema")) {
                        for (ExampleObject e : c.examples()) {
                            String v = e.value();
                            if (v.length() == 0) {
                                v = e.name();
                            }
                            if (v.length() <= 0) continue;
                            examples.add(new Example(v, cjson.getJSONObject("schema"), c.schema().type()));
                        }
                        continue;
                    }
                    logger.warn("no schema for {}", (Object)c);
                }
                catch (Exception e) {
                    logger.error("COULD NOT PARSE SCHEMA! {}", j, (Object)e);
                }
            }
            if (contentjson.length() > 0) {
                json.put(tag, (Object)contentjson);
            }
        }
    }

    public static void add(String tag, Header[] value, JSONObject json) {
        if (value.length > 0) {
            JSONObject contentjson = new JSONObject();
            for (Header c : value) {
                if (c.description().length() <= 0) continue;
                JSONObject cjson = new JSONObject();
                OpenApiParser.add("description", c.description(), cjson);
                OpenApiParser.add("schema", OpenApiParser.toJSON(c.schema()), cjson);
                if (c.deprecated()) {
                    OpenApiParser.add("deprecated", String.valueOf(c.deprecated()), cjson);
                }
                OpenApiParser.add("$ref", c.ref(), cjson);
                if (cjson.length() <= 0) continue;
                contentjson.put(c.name(), (Object)cjson);
            }
            if (contentjson.length() > 0) {
                json.put(tag, (Object)contentjson);
            }
        }
    }

    public static JSONObject toJSON(ExampleObject example) {
        JSONObject json = new JSONObject();
        if (example.ref().length() > 0) {
            OpenApiParser.add("$ref", example.ref(), json);
        } else {
            OpenApiParser.add("summary", example.summary(), json);
            OpenApiParser.add("description", example.description(), json);
            OpenApiParser.add("value", example.value(), json, true);
            if (!json.has("value")) {
                OpenApiParser.add("value", example.value(), json);
            }
            if (!json.has("value")) {
                OpenApiParser.add("value", example.name(), json);
            }
            OpenApiParser.add("externalValue", example.externalValue(), json);
        }
        return json;
    }

    public static void add(String tag, ExampleObject[] examples, JSONObject json) {
        JSONObject ex = new JSONObject();
        for (ExampleObject e : examples) {
            String name = e.name();
            if (name.length() == 0) {
                name = e.value();
            }
            ex.put(name, (Object)OpenApiParser.toJSON(e));
        }
        if (ex.length() > 0) {
            json.put(tag, (Object)ex);
        }
    }

    public static JSONObject toJSON(de.kosmos_lab.web.annotations.media.Schema schema) {
        JSONObject sjson = new JSONObject();
        if (schema.ref().length() > 0) {
            OpenApiParser.add("$ref", schema.ref(), sjson);
        } else {
            JSONArray jsonArray;
            OpenApiParser.add("type", schema.type().toString(), sjson);
            OpenApiParser.add("hidden", schema.hidden(), sjson, (Boolean)false);
            OpenApiParser.add("not", schema.not(), sjson);
            if (schema.notRef().length > 0) {
                jsonArray = new JSONArray();
                for (String ref : schema.notRef()) {
                    jsonArray.put((Object)new JSONObject().put("$ref", (Object)ref));
                }
                OpenApiParser.add("not", jsonArray, sjson);
            } else {
                OpenApiParser.add("not", schema.not(), sjson);
            }
            if (schema.oneOfRef().length > 0) {
                jsonArray = new JSONArray();
                for (String ref : schema.oneOfRef()) {
                    jsonArray.put((Object)new JSONObject().put("$ref", (Object)ref));
                }
                OpenApiParser.add("oneOf", jsonArray, sjson);
            } else {
                OpenApiParser.add("oneOf", schema.oneOf(), sjson);
            }
            if (schema.anyOfRef().length > 0) {
                jsonArray = new JSONArray();
                for (String ref : schema.anyOfRef()) {
                    jsonArray.put((Object)new JSONObject().put("$ref", (Object)ref));
                }
                OpenApiParser.add("anyOf", jsonArray, sjson);
            } else {
                OpenApiParser.add("anyOf", schema.anyOf(), sjson);
            }
            if (schema.allOfRef().length > 0) {
                jsonArray = new JSONArray();
                for (String ref : schema.allOfRef()) {
                    jsonArray.put((Object)new JSONObject().put("$ref", (Object)ref));
                }
                OpenApiParser.add("allOf", jsonArray, sjson);
            } else {
                OpenApiParser.add("allOf", schema.oneOf(), sjson);
            }
            OpenApiParser.add("title", schema.title(), sjson);
            OpenApiParser.add("multipleOf", schema.multipleOf(), sjson, 0.0);
            OpenApiParser.add("exclusiveMaximum", schema.exclusiveMaximum(), sjson, (Boolean)false);
            OpenApiParser.add("exclusiveMaximum", schema.exclusiveMaximum(), sjson, (Boolean)false);
            OpenApiParser.add("maxLength", schema.maxLength(), sjson, Integer.MAX_VALUE);
            OpenApiParser.add("minLength", schema.minLength(), sjson, 0);
            try {
                if (schema.minimum().length() > 0) {
                    OpenApiParser.add("minimum", Integer.parseInt(schema.minimum()), sjson, 0);
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            try {
                if (schema.maximum().length() > 0) {
                    OpenApiParser.add("maximum", Integer.parseInt(schema.maximum()), sjson, 0);
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            OpenApiParser.add("pattern", schema.pattern(), sjson);
            OpenApiParser.add("maxProperties", schema.maxProperties(), sjson, 0);
            OpenApiParser.add("minProperties", schema.minProperties(), sjson, 0);
            OpenApiParser.add("requiredProperties", schema.requiredProperties(), sjson);
            OpenApiParser.add("description", schema.description(), sjson);
            OpenApiParser.add("format", schema.format(), sjson);
            OpenApiParser.add("nullable", schema.nullable(), sjson, (Boolean)false);
            OpenApiParser.add("deprecated", schema.deprecated(), sjson, (Boolean)false);
            OpenApiParser.add("default", schema.defaultValue(), sjson);
            OpenApiParser.add("enum", schema.allowableValues(), sjson);
            OpenApiParser.add("externalDocs", schema.externalDocs(), sjson);
            OpenApiParser.add("discriminatorProperty", schema.discriminatorProperty(), sjson);
            OpenApiParser.add("DiscriminatorMapping", schema.discriminatorMapping(), sjson);
            OpenApiParser.add("additionalProperties", schema.additionalProperties(), sjson, true);
            OpenApiParser.add("subTypes", schema.subTypes(), sjson);
            if (schema.example().length() > 0) {
                OpenApiParser.add("example", schema.example(), sjson);
                examples.add(new Example(schema.example(), sjson, schema.type()));
            }
        }
        return sjson;
    }

    public static void add(String tag, de.kosmos_lab.web.annotations.media.Schema schema, JSONObject json) {
        JSONObject sjson = OpenApiParser.toJSON(schema);
        if (sjson.length() > 0) {
            json.put(tag, (Object)sjson);
        }
    }

    public static void add(String tag, DiscriminatorMapping[] value, JSONObject json) {
        if (value.length > 0) {
            // empty if block
        }
    }

    public static void add(String tag, ExternalDocumentation value, JSONObject json) {
        JSONObject j = new JSONObject();
        if (value.url().length() > 0) {
            j.put("url", (Object)value.url());
            json.put(tag, (Object)j);
        }
        if (value.description().length() > 0) {
            j.put("description", (Object)value.description());
            json.put(tag, (Object)j);
        }
    }

    public static void add(String tag, double value, JSONObject json, Double ignoreIfThis) {
        if (ignoreIfThis == null || ignoreIfThis != value) {
            json.put(tag, value);
        }
    }

    public static void add(String tag, Class<?>[] clzlist, JSONObject json) {
        JSONArray arr = new JSONArray();
        for (Class<?> clz : clzlist) {
            if (clz == Void.class) continue;
            arr.put((Object)clz.getName());
        }
        if (arr.length() > 0) {
            json.put(tag, (Object)arr);
        }
    }

    public static void add(String tag, Class<?> clz, JSONObject json) {
        if (clz != Void.class) {
            json.put(tag, (Object)clz.getName());
        }
    }

    public static void add(String tag, boolean value, JSONObject json, Boolean ignoreIfThis) {
        if (ignoreIfThis == null || ignoreIfThis != value) {
            json.put(tag, value);
        }
    }

    public static void add(String tag, int value, JSONObject json, Integer ignoreIfThis) {
        if (ignoreIfThis == null || ignoreIfThis != value) {
            json.put(tag, value);
        }
    }

    public static void add(String tag, JSONObject values, JSONObject json) {
        if (values != null && values.length() > 0) {
            json.put(tag, (Object)values);
        }
    }

    public static void add(String tag, JSONArray values, JSONObject json) {
        if (values != null && values.length() > 0) {
            json.put(tag, (Object)values);
        }
    }

    public static String getStringFromResource(String name) {
        String v;
        if (labels == null) {
            Locale locale = new Locale("en", "US");
            labels = ResourceBundle.getBundle("translation", locale);
        }
        if ((v = labels.getString(name)) != null) {
            return v;
        }
        missingFromResource.add(name);
        return name;
    }

    public static String prepareString(String input) {
        Matcher m = formatPattern.matcher(input);
        while (m.matches()) {
            if (m.groupCount() >= 2) {
                input = input.replaceFirst(formatRegex, OpenApiParser.getStringFromResource(m.group("key")));
            }
            m = formatPattern.matcher(input);
        }
        return input.replace("\n", "  \n");
    }

    public static void add(String tag, String value, JSONObject json) {
        if (value != null && value.length() > 0) {
            json.put(tag, (Object)OpenApiParser.prepareString(value));
        }
    }

    public static void add(String tag, String value, JSONObject json, boolean parseValue) {
        if (value != null && value.length() > 0) {
            if (parseValue) {
                if (value.equalsIgnoreCase("true")) {
                    json.put(tag, true);
                    return;
                }
                if (value.equalsIgnoreCase("false")) {
                    json.put(tag, false);
                    return;
                }
                if (value.startsWith("{")) {
                    try {
                        json.put(tag, (Object)new JSONObject(value));
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (value.startsWith("[")) {
                    try {
                        json.put(tag, (Object)new JSONArray(value));
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            json.put(tag, (Object)OpenApiParser.prepareString(value));
        }
    }

    public static void add(String tag, String[] values, JSONObject json) {
        if (values != null && values.length > 0) {
            JSONArray arr = new JSONArray();
            for (String v : values) {
                arr.put((Object)v);
            }
            json.put(tag, (Object)arr);
        }
    }

    static {
        examples = new LinkedList();
        responses = new JSONObject();
    }
}

