/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server;

import de.kosmos_lab.web.data.User;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyHttpServletRequest {
    protected static final Logger logger = LoggerFactory.getLogger((String)"MyHttpServletRequest");
    private final HttpServletRequest request;
    private JSONObject bodyJSONObject = null;
    private JSONArray bodyJSONArray = null;
    private String body = null;

    public MyHttpServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void checkParameter(String[] params) throws ParameterNotFoundException {
        for (String param : params) {
            this.checkParameter(param);
        }
    }

    private void checkParameter(String param) throws ParameterNotFoundException {
        if (this.getParameter(param) == null) {
            throw new ParameterNotFoundException(param);
        }
    }

    @Nonnull
    public String getBody() throws IOException {
        String line;
        if (this.body != null) {
            return this.body;
        }
        StringBuilder lines = new StringBuilder();
        while ((line = this.request.getReader().readLine()) != null) {
            lines.append(line);
            lines.append('\n');
        }
        this.body = lines.toString();
        return this.body;
    }

    public JSONArray getBodyAsJSONArray() {
        if (this.bodyJSONArray != null) {
            return this.bodyJSONArray;
        }
        try {
            String body = this.getBody();
            if (body.startsWith("[")) {
                JSONArray a;
                this.bodyJSONArray = a = new JSONArray(body);
                return a;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public JSONObject getBodyAsJSONObject() {
        if (this.bodyJSONObject != null) {
            return this.bodyJSONObject;
        }
        try {
            String body = this.getBody();
            if (body.startsWith("{")) {
                JSONObject o;
                this.bodyJSONObject = o = new JSONObject(body);
                return o;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new JSONObject();
    }

    public boolean getBoolean(String key) throws ParameterNotFoundException {
        String v = this.getParameter(key);
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        try {
            return this.getBodyAsJSONObject().getBoolean(key);
        }
        catch (JSONException jSONException) {
            throw new ParameterNotFoundException(key);
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String v = this.getParameter(key);
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        try {
            return this.getBodyAsJSONObject().optBoolean(key, defaultValue);
        }
        catch (JSONException jSONException) {
            return defaultValue;
        }
    }

    public double getDouble(String key) throws ParameterNotFoundException {
        String v = this.getParameter(key);
        if (v != null) {
            return Double.parseDouble(v);
        }
        try {
            return this.getBodyAsJSONObject().getDouble(key);
        }
        catch (JSONException jSONException) {
            throw new ParameterNotFoundException(key);
        }
    }

    public double getDouble(String key, double defaultValue) {
        String v = this.getParameter(key);
        if (v != null) {
            return Double.parseDouble(v);
        }
        try {
            return this.getBodyAsJSONObject().optDouble(key, defaultValue);
        }
        catch (JSONException jSONException) {
            return defaultValue;
        }
    }

    public int getInt(String key) throws ParameterNotFoundException {
        String v = this.getParameter(key);
        if (v != null) {
            return Integer.parseInt(v);
        }
        try {
            return this.getBodyAsJSONObject().getInt(key);
        }
        catch (JSONException jSONException) {
            throw new ParameterNotFoundException(key);
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            String v = this.getParameter(key);
            if (v != null) {
                return Integer.parseInt(v);
            }
        }
        catch (NullPointerException | NumberFormatException | SecurityException runtimeException) {
            // empty catch block
        }
        try {
            return this.getBodyAsJSONObject().optInt(key, defaultValue);
        }
        catch (JSONException jSONException) {
            return defaultValue;
        }
    }

    public String getParameter(String key) {
        String p = this.request.getParameter(key);
        if (p != null) {
            return p;
        }
        try {
            JSONObject o = this.getBodyAsJSONObject();
            if (o != null) {
                return o.get(key).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nonnull
    public String getParameter(String key, boolean throwException) throws ParameterNotFoundException {
        String r = this.getParameter(key);
        if (throwException && r == null) {
            throw new ParameterNotFoundException(key);
        }
        return r;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Nonnull
    public String getString(String key) throws ParameterNotFoundException {
        String v = this.getParameter(key);
        if (v != null) {
            return v;
        }
        throw new ParameterNotFoundException(key);
    }

    public String getString(String key, String defaultValue) {
        try {
            String value = this.getParameter(key);
            if (value != null) {
                return this.getParameter(key);
            }
        }
        catch (NullPointerException | SecurityException runtimeException) {
            // empty catch block
        }
        return defaultValue;
    }

    public User getUser() {
        return (User)this.request.getAttribute("user");
    }

    public Object getAttribute(String key) {
        return this.request.getAttribute(key);
    }
}

