/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.client;

import de.kosmos_lab.web.client.AuthedHTTPClient;
import de.kosmos_lab.web.client.exceptions.LoginFailedException;
import de.kosmos_lab.web.client.exceptions.RequestFailedException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTestClient
extends AuthedHTTPClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"MyClient");
    private final String user;
    private final String pass;
    boolean connected = false;
    private String token = null;

    public MyTestClient(@Nonnull String baseurl, @Nonnull String user, @Nonnull String pass) throws Exception {
        super(baseurl);
        this.user = user;
        this.pass = pass;
    }

    @Override
    public void authorizeRequest(@Nonnull Request request) throws LoginFailedException {
        if (this.token == null && !this.refreshToken()) {
            throw new LoginFailedException();
        }
        if (this.token != null) {
            request.header("Authorization", "Bearer " + this.token);
        }
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @CheckForNull
    public String login() {
        Request request = this.createRequest("/user/login", HttpMethod.POST);
        try {
            request.param("username", this.user);
            request.param("password", this.pass);
            ContentResponse response = request.send();
            if (response.getStatus() == 200) {
                return response.getContentAsString();
            }
            logger.warn("login status: {}", (Object)response.getStatus());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean refreshToken() {
        if (this.user != null && this.pass != null) {
            String t = this.login();
            if (t != null) {
                this.token = t;
                return true;
            }
        } else {
            this.token = "";
            return true;
        }
        return false;
    }

    public boolean refreshTokenIfNeeded() {
        if (this.token == null) {
            return this.refreshToken();
        }
        return true;
    }

    @Override
    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull Object body, int maxRetries, @CheckForNull Integer expectedStatus) throws RequestFailedException {
        return super.getResponse(url, method, body, maxRetries, expectedStatus);
    }

    @Override
    public void clearToken() {
        this.token = null;
    }
}

