/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.plugins.camera.reolink;

import de.kosmos_lab.platform.plugins.camera.ICamera;
import de.kosmos_lab.platform.plugins.camera.exceptions.VideoNotAvailableException;
import de.kosmos_lab.utils.FFMPEGWrapper;
import de.kosmos_lab.utils.KosmosFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class ReolinkCamera
implements ICamera {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ReolinkCamera");
    private final String password;
    private final String username;
    private final String base;
    private final HttpClient client;
    private final String name;
    private String mydir = "tmp";

    public ReolinkCamera(JSONObject options) {
        this.password = options.getString("password");
        this.username = options.getString("username");
        this.name = options.getString("name");
        this.base = options.getString("base") + "/cgi-bin/api.cgi?user=" + this.username + "&password=" + this.password;
        this.client = new HttpClient();
        try {
            this.client.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Calendar convertToCal(JSONObject json) {
        Calendar c = Calendar.getInstance();
        c.set(1, json.getInt("year"));
        c.set(5, json.getInt("day"));
        c.set(2, json.getInt("mon") - 1);
        c.set(11, json.getInt("hour"));
        c.set(12, json.getInt("min"));
        c.set(13, json.getInt("sec"));
        return c;
    }

    private JSONObject convertToJSON(Calendar cal) {
        JSONObject json = new JSONObject();
        json.put("year", cal.get(1));
        json.put("mon", cal.get(2) + 1);
        json.put("day", cal.get(5));
        json.put("hour", cal.get(11));
        json.put("min", cal.get(12));
        json.put("sec", cal.get(13));
        return json;
    }

    private Request createRequest(HttpMethod method, HashMap<String, String> parameters, JSONObject json) {
        Request request = this.client.newRequest(this.base);
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                request.param(e.getKey(), e.getValue());
            }
        }
        if (json != null) {
            request.content((ContentProvider)new StringContentProvider(json.toString()), "application/json");
        }
        request.method(method);
        request.agent("KosmoS Client");
        return request;
    }

    private Request createRequest(HttpMethod method, HashMap<String, String> parameters, JSONArray json) {
        return this.createRequest(null, method, parameters, json);
    }

    private Request createRequest(String url, HttpMethod method, HashMap<String, String> parameters, JSONArray json) {
        Request request = url != null ? this.client.newRequest(this.base + url) : this.client.newRequest(this.base);
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                request.param(e.getKey(), e.getValue());
            }
        }
        if (json != null) {
            request.content((ContentProvider)new StringContentProvider(json.toString()), "application/json");
        }
        request.method(method);
        request.agent("KosmoS Client");
        return request;
    }

    private void download(String name) {
        block15: {
            String fname = "tmp/" + name;
            logger.info("downloading recording {} to {}", (Object)name, (Object)fname);
            File f = new File(fname);
            if (!f.exists()) {
                logger.info("file does not exist yet");
                Request req = this.createRequest("&cmd=Download&source=" + name + "&ouptut=" + name, HttpMethod.GET, null, null);
                try {
                    InputStreamResponseListener listener = new InputStreamResponseListener();
                    req.send((Response.CompleteListener)listener);
                    Response response = listener.get(20L, TimeUnit.SECONDS);
                    if (response.getStatus() == 200) {
                        try (InputStream input = listener.getInputStream();){
                            byte[] bytes = input.readAllBytes();
                            logger.info("read {} for file {}", (Object)bytes.length, (Object)fname);
                            KosmosFileUtils.writeToFile((File)f, (byte[])bytes);
                            break block15;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break block15;
                    }
                    logger.warn("Status mismatch! {}", (Object)response.getStatus());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            } else {
                logger.info("file already downloaded");
            }
        }
    }

    public File getRecording(Calendar calStart, Calendar calEnd, long delta) throws VideoNotAvailableException {
        LinkedList<String> parts = new LinkedList<String>();
        JSONObject json = new JSONObject();
        if (calStart.after(calEnd)) {
            Calendar temp = calEnd;
            calEnd = calStart;
            calStart = temp;
        }
        StringBuilder concat = new StringBuilder();
        JSONArray array = new JSONArray();
        json.put("cmd", (Object)"Search");
        json.put("action", 1);
        JSONObject param = new JSONObject();
        JSONObject search = new JSONObject();
        search.put("channel", 0);
        search.put("onlyStatus", 0);
        search.put("streamType", (Object)"main");
        Calendar videostart = null;
        Calendar videoend = null;
        search.put("EndTime", (Object)this.convertToJSON(calEnd));
        search.put("StartTime", (Object)this.convertToJSON(calStart));
        param.put("Search", (Object)search);
        json.put("param", (Object)param);
        array.put((Object)json);
        logger.info("got json {}", (Object)json);
        String pattern = "yyyy-MM-dd_HH-mm-ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        String timePattern = "HH:mm:ss";
        String filename = this.name + "_" + simpleDateFormat.format(calStart.getTime());
        File jsonfile = new File(this.mydir + "/" + filename + ".json");
        File hashfile = new File(this.mydir + "/" + filename + ".txt");
        File outfile = new File(this.mydir + "/" + filename + ".mp4");
        if (outfile.exists()) {
            outfile.delete();
        }
        if (!(outfile.exists() && jsonfile.exists() && hashfile.exists())) {
            Request request = this.createRequest(HttpMethod.GET, null, array);
            try {
                ContentResponse response = request.send();
                String content = response.getContentAsString();
                JSONArray arr = new JSONArray(content);
                for (int i = 0; i < arr.length(); ++i) {
                    try {
                        JSONObject o = arr.getJSONObject(i);
                        if (o.has("value")) {
                            JSONArray files = o.getJSONObject("value").getJSONObject("SearchResult").getJSONArray("File");
                            for (int j = 0; j < files.length(); ++j) {
                                JSONObject f = files.getJSONObject(j);
                                logger.info("found file to get {}", (Object)f);
                                this.download(f.getString("name"));
                                parts.add(f.getString("name"));
                                Calendar s = this.convertToCal(f.getJSONObject("StartTime"));
                                Calendar e = this.convertToCal(f.getJSONObject("EndTime"));
                                if (videoend == null || e.after(videoend)) {
                                    videoend = e;
                                }
                                if (videostart != null && !s.before(videostart)) continue;
                                videostart = s;
                            }
                            logger.info("download finished - downloaded {} files", (Object)files.length());
                            continue;
                        }
                        logger.warn("NO DOWNLOAD!");
                        continue;
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            if (videoend == null) {
                logger.warn("COULD NOT DOWNLOAD VIDEOS!");
                throw new VideoNotAvailableException();
            }
            if (videostart == null) {
                logger.warn("COULD NOT DOWNLOAD VIDEOS!");
                throw new VideoNotAvailableException();
            }
            videostart.add(14, (int)(-delta));
            videoend.add(14, (int)(-delta));
            KosmosFileUtils.writeToFile((File)hashfile, (String)concat.toString());
            Locale locale = new Locale("en", "US");
            DateFormat dateFormat = DateFormat.getTimeInstance(0, locale);
            logger.info("startdate {} enddate {}", (Object)dateFormat.format(videostart.getTime()), (Object)dateFormat.format(videoend.getTime()));
            logger.info("wanted {} enddate {}", (Object)dateFormat.format(calStart.getTime()), (Object)dateFormat.format(calEnd.getTime()));
            long startDelta = calStart.getTimeInMillis() - videostart.getTimeInMillis();
            long wantedDuration = calEnd.getTimeInMillis() - calStart.getTimeInMillis();
            try {
                FFMPEGWrapper.mergeVideos(parts, (File)outfile, (long)startDelta, (long)wantedDuration);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            json = new JSONObject();
            json.put("videostart", videostart.getTimeInMillis() - delta);
            json.put("videoend", videoend.getTimeInMillis() - delta);
            KosmosFileUtils.writeToFile((File)jsonfile, (String)json.toString());
        } else {
            json = new JSONObject(KosmosFileUtils.readFile((File)jsonfile));
            videoend = Calendar.getInstance();
            videoend.setTimeInMillis(json.getLong("videoend") - delta);
            videostart = Calendar.getInstance();
            videostart.setTimeInMillis(json.getLong("videostart") - delta);
        }
        logger.info("download done");
        return outfile;
    }

    public byte[] getSnapshot() {
        byte[] bytes;
        block13: {
            bytes = null;
            Request req = this.createRequest("&cmd=Snap&channel=0", HttpMethod.GET, null, null);
            try {
                InputStreamResponseListener listener = new InputStreamResponseListener();
                req.send((Response.CompleteListener)listener);
                Response response = listener.get(20L, TimeUnit.SECONDS);
                if (response.getStatus() == 200) {
                    try (InputStream input = listener.getInputStream();){
                        bytes = input.readAllBytes();
                        break block13;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block13;
                }
                logger.warn("Status mismatch! {}", (Object)response.getStatus());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return bytes;
    }

    public void stop() {
        try {
            this.client.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

