/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.OwnerShipPolicyKind;
import us.ihmc.pubsub.attributes.ReaderQosHolder;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSCommonFunctions;
import us.ihmc.rtps.impl.fastRTPS.ReaderQos;
import us.ihmc.rtps.impl.fastRTPS.stringVector;

class FastRTPSReaderQosHolder
implements ReaderQosHolder {
    private final boolean ownMemory;
    private final ReaderQos readerQos = new ReaderQos();

    FastRTPSReaderQosHolder() {
        this.ownMemory = true;
    }

    public FastRTPSReaderQosHolder(ReaderQos readerQos) {
        this();
        this.readerQos.setQos(readerQos, true);
    }

    public void delete() {
        if (this.ownMemory) {
            this.getReaderQos().delete();
        }
    }

    public void finalize() {
        this.delete();
    }

    @Override
    public void setReliabilityKind(ReliabilityKind reliabilityKind) {
        this.getReaderQos().getM_reliability().setKind(FastRTPSCommonFunctions.toCppReliabilityQosPolicyKind(reliabilityKind));
    }

    @Override
    public ReliabilityKind getReliabilityKind() {
        return FastRTPSCommonFunctions.toJavaReliabilityKind(this.getReaderQos().getM_reliability().getKind());
    }

    public ReaderQos getReaderQos() {
        return this.readerQos;
    }

    @Override
    public DurabilityKind getDurabilityKind() {
        return FastRTPSCommonFunctions.toJavaDurabilityKind(this.getReaderQos().getM_durability().getKind());
    }

    @Override
    public void setDurabilityKind(DurabilityKind durabilityKind) {
        this.getReaderQos().getM_durability().setKind(FastRTPSCommonFunctions.toCppDurabilityKind(durabilityKind));
    }

    @Override
    public OwnerShipPolicyKind getOwnershipPolicyKind() {
        return FastRTPSCommonFunctions.toJavaOwnershipQosPolicyKind(this.getReaderQos().getM_ownership().getKind());
    }

    @Override
    public void setOwnershipPolicyKind(OwnerShipPolicyKind ownerShipPolicyKind) {
        this.getReaderQos().getM_ownership().setKind(FastRTPSCommonFunctions.toCppOwnershipQosPolicyKind(ownerShipPolicyKind));
    }

    @Override
    public void addPartition(String name) {
        this.getReaderQos().getM_partition().push_back(name);
    }

    @Override
    public List<String> getPartitions() {
        ArrayList<String> partitions = new ArrayList<String>();
        stringVector CppPartitions = this.getReaderQos().getM_partition().getNames();
        int i = 0;
        while ((long)i < CppPartitions.size()) {
            partitions.add(CppPartitions.get(i));
            ++i;
        }
        return Collections.unmodifiableList(partitions);
    }
}

