/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.TopicAttributes;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSCommonFunctions;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSPublisherAttributes;
import us.ihmc.rtps.impl.fastRTPS.LocatorList_t;
import us.ihmc.rtps.impl.fastRTPS.MatchingStatus;
import us.ihmc.rtps.impl.fastRTPS.MemoryManagementPolicy_t;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantImpl;
import us.ihmc.rtps.impl.fastRTPS.NativePublisherImpl;
import us.ihmc.rtps.impl.fastRTPS.NativePublisherListener;
import us.ihmc.rtps.impl.fastRTPS.ThroughputControllerDescriptor;
import us.ihmc.rtps.impl.fastRTPS.TopicAttributes;
import us.ihmc.rtps.impl.fastRTPS.WriterQos;

class FastRTPSPublisher
implements Publisher {
    private final Object destructorLock = new Object();
    private NativePublisherImpl impl;
    private final FastRTPSPublisherAttributes attributes;
    private final TopicDataType<Object> topicDataType;
    private final PublisherListener listener;
    private final SerializedPayload payload;
    private TopicAttributes fastRTPSAttributes;
    private ThroughputControllerDescriptor throughputController;
    private final Guid guid = new Guid();
    private final ByteBuffer keyBuffer = ByteBuffer.allocateDirect(16);
    private final NativePublisherListenerImpl nativeListenerImpl = new NativePublisherListenerImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FastRTPSPublisher(TopicDataType<?> topicDataTypeIn, FastRTPSPublisherAttributes attributes, PublisherListener listener, NativeParticipantImpl participant) throws IOException, IllegalArgumentException {
        Object object = this.destructorLock;
        synchronized (object) {
            LocatorList_t unicastLocatorList = new LocatorList_t();
            FastRTPSCommonFunctions.convertToCPPLocatorList(attributes.getUnicastLocatorList(), unicastLocatorList);
            LocatorList_t multicastLocatorList = new LocatorList_t();
            FastRTPSCommonFunctions.convertToCPPLocatorList(attributes.getMulticastLocatorList(), multicastLocatorList);
            LocatorList_t outLocatorList = new LocatorList_t();
            FastRTPSCommonFunctions.convertToCPPLocatorList(attributes.getOutLocatorList(), outLocatorList);
            if (!unicastLocatorList.isValid()) {
                throw new IllegalArgumentException("Unicast Locator List for Publisher contains invalid Locator");
            }
            if (!multicastLocatorList.isValid()) {
                throw new IllegalArgumentException(" Multicast Locator List for Publisher contains invalid Locator");
            }
            if (!outLocatorList.isValid()) {
                throw new IllegalArgumentException("Output Locator List for Publisher contains invalid Locator");
            }
            this.attributes = attributes;
            this.topicDataType = topicDataTypeIn.newInstance();
            this.listener = listener;
            this.payload = new SerializedPayload(this.topicDataType.getTypeSize());
            this.fastRTPSAttributes = attributes.createFastRTPSTopicAttributes();
            this.throughputController = attributes.createTroughputControllerDescriptor();
            WriterQos qos = attributes.getQos().getWriterQos();
            if (!qos.checkQos() || !this.fastRTPSAttributes.checkQos()) {
                throw new IllegalArgumentException("Invalid QoS settings");
            }
            this.impl = new NativePublisherImpl(attributes.getEntityID(), attributes.getUserDefinedID(), this.topicDataType.getTypeSize(), MemoryManagementPolicy_t.swigToEnum(attributes.getHistoryMemoryPolicy().ordinal()), this.fastRTPSAttributes, qos, attributes.getTimes(), unicastLocatorList, multicastLocatorList, outLocatorList, this.throughputController, participant, this.nativeListenerImpl);
            if (!this.impl.createPublisher()) {
                throw new IOException("Cannot create publisher");
            }
            this.guid.fromPrimitives(this.impl.getGuidHigh(), this.impl.getGuidLow());
            unicastLocatorList.delete();
            multicastLocatorList.delete();
            outLocatorList.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object data) throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            this.serializeMessage(data);
            this.impl.write(this.payload.getData(), this.payload.getLength(), this.payload.getEncapsulation(), this.keyBuffer, this.keyBuffer.position());
        }
    }

    private void serializeMessage(Object data) throws IOException {
        if (this.attributes.getTopic().getTopicKind() == TopicAttributes.TopicKind.WITH_KEY) {
            this.keyBuffer.clear();
            this.topicDataType.getKey(data, this.keyBuffer);
        }
        this.payload.getData().clear();
        this.topicDataType.serialize(data, this.payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(Object data) throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            this.serializeMessage(data);
            this.impl.dispose(this.payload.getData(), this.payload.getLength(), this.payload.getEncapsulation(), this.keyBuffer, this.keyBuffer.position());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Object data) throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            this.serializeMessage(data);
            this.impl.unregister(this.payload.getData(), this.payload.getLength(), this.payload.getEncapsulation(), this.keyBuffer, this.keyBuffer.position());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose_and_unregister(Object data) throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            this.serializeMessage(data);
            this.impl.dispose_and_unregister(this.payload.getData(), this.payload.getLength(), this.payload.getEncapsulation(), this.keyBuffer, this.keyBuffer.position());
        }
    }

    @Override
    public Guid getGuid() {
        return this.guid;
    }

    @Override
    public PublisherAttributes getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        Object object = this.destructorLock;
        synchronized (object) {
            this.impl.delete();
            this.nativeListenerImpl.delete();
            this.fastRTPSAttributes.delete();
            this.throughputController.delete();
            this.impl = null;
        }
    }

    public void finalize() {
        this.delete();
    }

    @Override
    public int removeAllChange() throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            int removed = this.impl.removeAllChange();
            if (removed >= 0) {
                return removed;
            }
            throw new IOException("Cannot remove all changes");
        }
    }

    public TopicDataType<?> getTopicDataType() {
        return this.topicDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        Object object = this.destructorLock;
        synchronized (object) {
            return this.impl != null;
        }
    }

    private class NativePublisherListenerImpl
    extends NativePublisherListener {
        private final MatchingInfo matchingInfo = new MatchingInfo();

        private NativePublisherListenerImpl() {
        }

        @Override
        public void onWriterMatched(MatchingStatus status, long guidHigh, long guidLow) {
            try {
                if (FastRTPSPublisher.this.listener != null) {
                    this.matchingInfo.getGuid().fromPrimitives(guidHigh, guidLow);
                    this.matchingInfo.setStatus(MatchingInfo.MatchingStatus.values[status.swigValue()]);
                    FastRTPSPublisher.this.listener.onPublicationMatched(FastRTPSPublisher.this, this.matchingInfo);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

