/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.intraprocess;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.OwnerShipPolicyKind;
import us.ihmc.pubsub.attributes.QosInterface;
import us.ihmc.pubsub.attributes.ReliabilityKind;

abstract class IntraProcessQosInterface
implements QosInterface {
    private OwnerShipPolicyKind ownership;
    private ReliabilityKind reliability;
    private DurabilityKind durability;
    private final List<String> partitions = new ArrayList<String>();

    IntraProcessQosInterface() {
        this.ownership = OwnerShipPolicyKind.SHARED_OWNERSHIP_QOS;
        this.reliability = ReliabilityKind.RELIABLE;
        this.durability = DurabilityKind.VOLATILE_DURABILITY_QOS;
    }

    IntraProcessQosInterface(IntraProcessQosInterface orig) {
        this.ownership = orig.ownership;
        this.reliability = orig.reliability;
        this.durability = orig.durability;
        this.partitions.addAll(orig.partitions);
    }

    @Override
    public void setReliabilityKind(ReliabilityKind reliabilityKind) {
        this.reliability = reliabilityKind;
    }

    @Override
    public ReliabilityKind getReliabilityKind() {
        return this.reliability;
    }

    @Override
    public DurabilityKind getDurabilityKind() {
        return this.durability;
    }

    @Override
    public void setDurabilityKind(DurabilityKind durabilityKind) {
        this.durability = durabilityKind;
    }

    @Override
    public OwnerShipPolicyKind getOwnershipPolicyKind() {
        return this.ownership;
    }

    @Override
    public void setOwnershipPolicyKind(OwnerShipPolicyKind ownerShipPolicyKind) {
        this.ownership = ownerShipPolicyKind;
    }

    @Override
    public void addPartition(String name) {
        this.partitions.add(name);
    }

    @Override
    public List<String> getPartitions() {
        return this.partitions;
    }
}

