/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.NotImplementedException;
import us.ihmc.idl.IDLSequence;
import us.ihmc.pubsub.common.SerializedPayload;

public class CDR {
    private static final int encapsulation_size = 4;
    public static final int UNSIGNED_SHORT_MAX = 65535;
    public static final long UNSIGNED_INT_MAX = 0xFFFFFFFFL;
    private SerializedPayload payload;
    private ByteBuffer buf;
    private static short options = 0;

    public static int alignment(int current_alignment, int dataSize) {
        return dataSize - current_alignment % dataSize & dataSize - 1;
    }

    public void serialize(SerializedPayload payload) {
        CDR.writeEncapsulation(payload);
        this.buf = payload.getData();
        this.payload = payload;
    }

    public static void writeEncapsulation(SerializedPayload payload) {
        ByteBuffer buf = payload.getData();
        buf.put((byte)0);
        buf.put((byte)payload.getEncapsulation());
        buf.putShort(options);
    }

    public void deserialize(SerializedPayload payload) {
        CDR.readEncapsulation(payload);
        this.buf = payload.getData();
        this.payload = payload;
    }

    public static void readEncapsulation(SerializedPayload payload) {
        ByteBuffer buf = payload.getData();
        buf.get();
        short encapsulation = buf.get();
        payload.setEncapsulation(encapsulation);
        buf.getShort();
    }

    public void finishSerialize() {
        this.buf.flip();
        this.payload.setLength(this.buf.limit());
    }

    public void finishDeserialize() {
    }

    public static int getTypeSize(int elementTypeSize) {
        return elementTypeSize + 4;
    }

    public short read_type_1() {
        this.align(2);
        return this.buf.getShort();
    }

    public void write_type_1(short val) {
        this.align(2);
        this.buf.putShort(val);
    }

    public int read_type_2() {
        this.align(4);
        return this.buf.getInt();
    }

    public void write_type_2(int val) {
        this.align(4);
        this.buf.putInt(val);
    }

    public int read_type_3() {
        return Short.toUnsignedInt(this.read_type_1());
    }

    public void write_type_3(int val) {
        if (val < 0) {
            throw new ArithmeticException("(CDR.java:134): int " + val + " cannot be cast to unsigned short. cannot be negative");
        }
        if (val > 65535) {
            throw new ArithmeticException("(CDR.java:134): int " + val + " cannot be cast to unsigned short. UNSIGNED_SHORT_MAX = " + 65535);
        }
        this.write_type_1((short)val);
    }

    public long read_type_4() {
        return Integer.toUnsignedLong(this.read_type_2());
    }

    public void write_type_4(long val) {
        if (val < 0L) {
            throw new ArithmeticException("(CDR.java:134): long " + val + " cannot be cast to unsigned int. cannot be negative");
        }
        if (val > 0xFFFFFFFFL) {
            throw new ArithmeticException("(CDR.java:134): long " + val + " cannot be cast to unsigned int. UNSIGNED_INT_MAX = " + 0xFFFFFFFFL);
        }
        this.write_type_2((int)val);
    }

    public float read_type_5() {
        this.align(4);
        return this.buf.getFloat();
    }

    public void write_type_5(float val) {
        this.align(4);
        this.buf.putFloat(val);
    }

    public double read_type_6() {
        this.align(8);
        return this.buf.getDouble();
    }

    public void write_type_6(double val) {
        this.align(8);
        this.buf.putDouble(val);
    }

    public boolean read_type_7() {
        byte val = this.read_type_9();
        return val != 0;
    }

    public void write_type_7(boolean val) {
        this.write_type_9(val ? (byte)1 : 0);
    }

    public char read_type_8() {
        return (char)(this.buf.get() & 0xFF);
    }

    public void write_type_8(char val) {
        this.buf.put((byte)val);
    }

    public byte read_type_9() {
        return this.buf.get();
    }

    public void write_type_9(byte val) {
        this.buf.put(val);
    }

    public Object read_type_b() {
        throw new NotImplementedException("Union types are not implemented yet");
    }

    public void write_type_b(Object object) {
        throw new NotImplementedException("Union types are not implemented yet");
    }

    public int read_type_c() {
        return this.read_type_2();
    }

    public void write_type_c(int val) {
        this.write_type_2(val);
    }

    public void read_type_d(StringBuilder res) {
        int length = this.read_type_2() - 1;
        res.setLength(length);
        for (int i = 0; i < length; ++i) {
            res.setCharAt(i, (char)this.buf.get());
        }
        this.buf.get();
    }

    public void write_type_d(StringBuilder str) {
        this.write_type_2(str.length() + 1);
        for (int i = 0; i < str.length(); ++i) {
            this.buf.put((byte)str.charAt(i));
        }
        this.buf.put((byte)0);
    }

    public void read_type_e(IDLSequence seq) {
        int length = this.read_type_2();
        seq.resetQuick();
        for (int i = 0; i < length; ++i) {
            seq.readElement(i, this);
        }
    }

    public void write_type_e(IDLSequence seq) {
        int length = seq.size();
        this.write_type_2(length);
        for (int i = 0; i < length; ++i) {
            seq.writeElement(i, this);
        }
    }

    public void read_type_f() {
    }

    public long read_type_11() {
        this.align(8);
        return this.buf.getLong();
    }

    public void write_type_11(long val) {
        this.align(8);
        this.buf.putLong(val);
    }

    public long read_type_12() {
        return this.read_type_11();
    }

    public void write_type_12(long val) {
        this.write_type_11(val);
    }

    public double read_type_13() {
        throw new NotImplementedException("Java does not support 16 byte Double values");
    }

    public void write_type_13(double val) {
        throw new NotImplementedException("Java does not support 16 byte Double values");
    }

    public char read_type_14() {
        return (char)this.read_type_2();
    }

    public void write_type_14(char val) {
        this.write_type_2(val);
    }

    public void read_type_15(StringBuilder res) {
        int length = this.read_type_2();
        res.setLength(length);
        for (int i = 0; i < length; ++i) {
            res.setCharAt(i, this.buf.getChar());
        }
    }

    public void write_type_15(StringBuilder str) {
        this.write_type_2(str.length());
        for (int i = 0; i < str.length(); ++i) {
            this.buf.putChar(str.charAt(i));
        }
    }

    public int align(int byteBoundary) {
        int position = this.buf.position() - 4;
        int adv = position % byteBoundary;
        if (adv != 0) {
            this.buf.position(position + 4 + (byteBoundary - adv));
        }
        return adv;
    }
}

