/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server.servlets.openapi;

import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.server.WebServer;
import de.kosmos_lab.web.server.servlets.BaseServlet;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/doc/asyncapi.yaml", userLevel=-1)
public class AsyncApiYamlServlet
extends BaseServlet {
    public AsyncApiYamlServlet(WebServer webServer) {
        super(webServer);
    }

    @Override
    @Operation(tags={"asyncApi"}, summary="asyncapi.yaml", description="The generated asyncApi specification for this service in YAML format", responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="The generated asyncApi specification for this service")})
    public void get(BaseServletRequest request, HttpServletResponse response) throws IOException {
        String host = null;
        try {
            host = request.getParameter("host", false);
        }
        catch (ParameterNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (host == null) {
            try {
                host = request.getRequest().getHeader("host");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (host != null) {
            AsyncApiYamlServlet.sendTextAs(request, response, this.server.replaceHostName(this.server.getAsyncApiParser().getCachedYAML(), host), "text/x-yaml");
        } else {
            AsyncApiYamlServlet.sendTextAs(request, response, this.server.getAsyncApiParser().getCachedYAML(), "text/x-yaml");
        }
    }
}

