/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server;

import de.kosmos_lab.web.server.WebSocketService;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketCreator
implements JettyWebSocketCreator {
    private static final Logger logger = LoggerFactory.getLogger((String)"KosmosWebSocketCreator");
    private WebSocketService binaryService;
    private WebSocketService textService;

    public WebSocketCreator(WebSocketService textService, WebSocketService binaryService) {
        this.textService = textService;
        this.binaryService = binaryService;
    }

    public Object createWebSocket(JettyServerUpgradeRequest req, JettyServerUpgradeResponse resp) {
        for (String subprotocol : req.getSubProtocols()) {
            logger.info("found subprotocol {}", (Object)subprotocol);
            if ("binary".equals(subprotocol)) {
                resp.setAcceptedSubProtocol(subprotocol);
                return this.binaryService;
            }
            if (!"text".equals(subprotocol)) continue;
            resp.setAcceptedSubProtocol(subprotocol);
            return this.textService;
        }
        if (this.textService != null) {
            return this.textService;
        }
        if (this.binaryService != null) {
            return this.binaryService;
        }
        return null;
    }
}

