/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.persistence;

import de.kosmos_lab.utils.FileUtils;
import de.kosmos_lab.utils.StringFunctions;
import de.kosmos_lab.web.data.User;
import de.kosmos_lab.web.exceptions.LoginFailedException;
import de.kosmos_lab.web.persistence.ControllerWithPersistence;
import de.kosmos_lab.web.persistence.ISesssionPersistence;
import de.kosmos_lab.web.persistence.IUserPersistence;
import de.kosmos_lab.web.server.JWT;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPersistence
implements IUserPersistence,
ISesssionPersistence {
    private static final Logger logger = LoggerFactory.getLogger((String)"JSONPersistence");
    private final ControllerWithPersistence server;
    private final File file;
    protected JSONObject json;
    protected ConcurrentHashMap<String, User> users;
    protected ConcurrentHashMap<UUID, User> usersByUUID;
    protected ConcurrentHashMap<String, String> sessions;

    public JSONPersistence(ControllerWithPersistence server, File storageFile) {
        File distFile;
        this.prepare();
        this.server = server;
        this.file = storageFile;
        if (!storageFile.exists() && (distFile = new File(storageFile.getAbsolutePath() + ".dist")).exists()) {
            try {
                Files.copy(distFile.toPath(), this.file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        JSONObject tempJson = new JSONObject();
        try {
            tempJson = new JSONObject(FileUtils.readFile((File)storageFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new RuntimeException("COULD NOT READ STORAGE FILE " + storageFile.getName());
        }
        this.json = tempJson;
        this.init();
        this.save();
    }

    @Override
    public void addJWT(@Nonnull String token) {
        try {
            JSONObject o = this.server.getJwt().verify(token);
            this.sessions.put(o.getString("jwtid"), token);
            this.save();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (JWT.JWTVerifyFailed e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean addUser(@CheckForNull String username, @CheckForNull String password, int level) {
        if (username == null) {
            throw new IllegalArgumentException();
        }
        if (password == null) {
            throw new IllegalArgumentException();
        }
        if (this.users.containsKey(username.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        String salt = StringFunctions.generateRandomKey();
        User u = new User(this.server, this.server.generateUUID(), username, this.server.hashSaltPepper(password, salt), salt, level);
        this.cacheUser(u);
        this.save();
        return true;
    }

    private void cacheUser(String UsernameLowerCased, User user) {
        this.users.put(UsernameLowerCased.toLowerCase(), user);
        this.usersByUUID.put(user.getUUID(), user);
    }

    public void cacheUser(User user) {
        this.cacheUser(user.getName().toLowerCase(Locale.ENGLISH), user);
        this.server.addUUID(user.getUUID(), user);
    }

    public void doSave() {
        try {
            FileUtils.writeToFile((File)this.file, (String)this.json.toString());
        }
        catch (IOException e) {
            logger.error("CONFIG COULD NOT BE SAVED!");
        }
    }

    @Override
    public JSONObject getJWT(@Nonnull String jwtid) {
        try {
            String token = this.sessions.get(jwtid);
            if (token != null) {
                return this.server.getJwt().verify(token);
            }
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (JWT.JWTVerifyFailed jWTVerifyFailed) {
            // empty catch block
        }
        this.sessions.remove(jwtid);
        this.save();
        return null;
    }

    @Override
    public String getJWT(@Nonnull User user) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        String jwt = this.server.getJwt().sign(user.toJWT());
        this.addJWT(jwt);
        return jwt;
    }

    @Override
    public Collection<JSONObject> getMySessions(String username) {
        LinkedList<JSONObject> list = new LinkedList<JSONObject>();
        String ul = username.toLowerCase(Locale.ENGLISH);
        for (String jwtid : this.sessions.keySet()) {
            JSONObject o = this.getJWT(jwtid);
            if (o == null || !ul.equals(o.getString("name"))) continue;
            list.add(o);
        }
        return list;
    }

    public ControllerWithPersistence getController() {
        return this.server;
    }

    @Override
    public User getUser(@CheckForNull String username) {
        if (username != null) {
            String ul = username.toLowerCase(Locale.ENGLISH);
            return this.users.get(ul);
        }
        return null;
    }

    @Override
    public User getUser(@CheckForNull UUID uuid) {
        if (uuid != null) {
            return this.usersByUUID.get(uuid);
        }
        return null;
    }

    protected void init() {
        logger.info("Read {} Users", (Object)this.initUsers());
        logger.info("Read {} Sessions", (Object)this.initSesssions());
    }

    @Override
    public int initSesssions() {
        int read = 0;
        JSONObject tempJson = this.json.optJSONObject("jwtsessions");
        if (tempJson != null) {
            for (String jwtid : tempJson.keySet()) {
                this.sessions.put(jwtid, tempJson.getString(jwtid));
                ++read;
            }
        }
        return read;
    }

    @Override
    public int initUsers() {
        int read = 0;
        JSONObject tempJson = this.json.optJSONObject("users");
        if (tempJson != null) {
            for (String key : tempJson.keySet()) {
                this.users.put(key.toLowerCase(Locale.ENGLISH), new User(this, tempJson.getJSONObject(key)));
                ++read;
            }
        }
        return read;
    }

    @Override
    public void killJWT(String jwtid) {
        if (this.sessions.remove(jwtid) != null) {
            this.save();
        }
    }

    @Override
    public User login(@CheckForNull String username, @CheckForNull String password) throws LoginFailedException {
        String ul;
        User u;
        if (username != null && password != null && (u = this.getUser(ul = username.toLowerCase(Locale.ENGLISH))) != null) {
            if (u.checkPassword(password)) {
                return u;
            }
            logger.warn("mismatched password for user {}", (Object)username);
        }
        throw new LoginFailedException();
    }

    public void prepare() {
        this.sessions = new ConcurrentHashMap();
        this.users = new ConcurrentHashMap();
        this.usersByUUID = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        JSONObject jSONObject = this.json;
        synchronized (jSONObject) {
            JSONObject tempJSON = new JSONObject();
            for (Map.Entry<String, String> entry : this.sessions.entrySet()) {
                JSONObject token = null;
                try {
                    token = this.server.getJwt().verify(entry.getValue());
                    tempJSON.put(entry.getKey(), (Object)entry.getValue());
                }
                catch (InvalidKeyException exception) {
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (JWT.JWTVerifyFailed | UnsupportedEncodingException exception) {
                    // empty catch block
                }
                if (token != null) continue;
                this.sessions.remove(entry.getKey());
            }
            this.json.put("jwtsessions", (Object)tempJSON);
            tempJSON = new JSONObject();
            for (Map.Entry<String, Object> entry : this.users.entrySet()) {
                tempJSON.put(entry.getKey(), (Object)((User)entry.getValue()).toJSON());
            }
            this.json.put("users", (Object)tempJSON);
            this.doSave();
        }
    }

    @Override
    public JSONObject verifyJWT(@Nonnull String token) {
        try {
            JSONObject o = this.server.getJwt().verify(token);
            if (o.has("jwtid") && this.sessions.containsKey(o.getString("jwtid"))) {
                return o;
            }
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (JWT.JWTVerifyFailed e) {
            e.printStackTrace();
        }
        return null;
    }
}

