/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.client.websocket;

import de.kosmos_lab.web.client.websocket.SimpleWebSocketEndpoint;
import jakarta.websocket.ClientEndpoint;
import java.net.URI;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class WebSocketTestClient
extends SimpleWebSocketEndpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)"WebSocketTestClient");
    private Queue<String> listMessages = new ConcurrentLinkedQueue<String>();
    JSONObject json = new JSONObject();

    public void set(String key, Object value) {
        this.json.put(key, value);
    }

    public JSONObject getObjects() {
        return this.json;
    }

    public WebSocketTestClient(URI endpointURI) {
        super(endpointURI);
        this.addMessageHandler(new SimpleWebSocketEndpoint.MessageHandler(){

            @Override
            public void handleMessage(String message) {
                logger.info("got message: {}", (Object)message);
                WebSocketTestClient.this.listMessages.add(message);
            }
        });
    }

    public boolean hasMessage(String message) {
        return this.listMessages.contains(message);
    }
}

