/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.client.websocket;

import de.kosmos_lab.web.client.websocket.SimpleWebSocketEndpoint;
import de.kosmos_lab.web.client.websocket.WebSocketClientEndpoint;
import de.kosmos_lab.web.client.websocket.WebSocketEventConsumer;
import de.kosmos_lab.web.client.websocket.handlers.IOnConnected;
import de.kosmos_lab.web.client.websocket.handlers.IOnDisconnected;
import de.kosmos_lab.web.client.websocket.handlers.IOnMessage;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.MultiPartContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.glassfish.tyrus.client.ClientManager;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"WebSocketClient");
    private final String user;
    private final String pass;
    private final String base;
    private final String wspath;
    boolean stopped = false;
    private String token;
    private WebSocketClientEndpoint endpoint;
    Set<IOnConnected> handlerOnConnect = ConcurrentHashMap.newKeySet();
    Set<IOnMessage> handlerOnMessage = ConcurrentHashMap.newKeySet();
    Set<IOnDisconnected> handlerOnDisconnect = ConcurrentHashMap.newKeySet();
    ConcurrentHashMap<String, Queue<SimpleWebSocketEndpoint.MessageHandler>> mapMessageHandler = new ConcurrentHashMap();
    ConcurrentHashMap<Pattern, Queue<SimpleWebSocketEndpoint.RegexMessageHandler>> mapRegexMessageHandler = new ConcurrentHashMap();

    public WebSocketClientEndpoint getEndpoint() {
        return this.endpoint;
    }

    public WebSocketClient(String base, String user, String pass, String wspath, WebSocketClientEndpoint endpoint) {
        this.base = base;
        this.user = user;
        this.pass = pass;
        this.wspath = wspath;
        this.setConnectTimeout(5000L);
        this.endpoint = endpoint;
        try {
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEndpoint(WebSocketClientEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void connect() {
        final WebSocketClient c = this;
        new Thread(){

            @Override
            public void run() {
                while (!WebSocketClient.this.stopped) {
                    try {
                        ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
                        ClientManager client = ClientManager.createClient();
                        if (WebSocketClient.this.endpoint == null) {
                            WebSocketClient.this.endpoint = new WebSocketClientEndpoint(c){

                                @Override
                                public void wsOnOpen(Session session) {
                                    WebSocketClient.this.triggerOnOpen();
                                }

                                @Override
                                public void wsOnClose(Session session, CloseReason reason) {
                                    WebSocketClient.this.triggerOnClose(reason);
                                }

                                @Override
                                public void wsOnMessage(Session session, String message) {
                                    logger.info("WS Client got message {}", (Object)message);
                                    for (Map.Entry<String, Queue<SimpleWebSocketEndpoint.MessageHandler>> entry : WebSocketClient.this.mapMessageHandler.entrySet()) {
                                        try {
                                            if (!entry.getKey().equals(message)) continue;
                                            for (SimpleWebSocketEndpoint.MessageHandler messageHandler : entry.getValue()) {
                                                messageHandler.handleMessage(message);
                                            }
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                    for (Map.Entry<Object, Queue<Object>> entry : WebSocketClient.this.mapRegexMessageHandler.entrySet()) {
                                        try {
                                            Matcher m = ((Pattern)entry.getKey()).matcher(message);
                                            if (!m.matches()) continue;
                                            for (SimpleWebSocketEndpoint.RegexMessageHandler regexMessageHandler : entry.getValue()) {
                                                regexMessageHandler.handleMessage(message, m);
                                            }
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                    WebSocketClient.this.triggerOnMessage(message);
                                }
                            };
                        }
                        URI uri = new URI(WebSocketClient.this.getBase().replace("https:", "wss:").replace("http:", "ws:") + WebSocketClient.this.wspath);
                        logger.info("WS trying to connect to {}", (Object)uri);
                        client.connectToServer((Object)WebSocketClient.this.endpoint, uri);
                        while (!WebSocketClient.this.endpoint.stopped) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Exception!", (Throwable)e);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Exception!", (Throwable)e);
                    }
                }
            }
        }.start();
    }

    public void addHandler(IOnConnected handler) {
        this.handlerOnConnect.add(handler);
    }

    public void addHandler(IOnMessage handler) {
        this.handlerOnMessage.add(handler);
    }

    public void send(String message) throws IOException {
        this.endpoint.send(message);
    }

    public void addHandler(IOnDisconnected handler) {
        this.handlerOnDisconnect.add(handler);
    }

    private void triggerOnOpen() {
        for (IOnConnected handler : this.handlerOnConnect) {
            handler.onConnect();
        }
    }

    private void triggerOnMessage(String message) {
        for (IOnMessage handler : this.handlerOnMessage) {
            handler.onMessage(message);
        }
    }

    private void triggerOnClose(CloseReason closeReason) {
        for (IOnDisconnected handler : this.handlerOnDisconnect) {
            handler.onDisconnected(closeReason);
        }
    }

    private Request createRequest(String url, HttpMethod method) {
        if (!((String)url).startsWith("http")) {
            url = this.base + (String)url;
        }
        logger.trace("creating request for {}", url);
        Request request = this.newRequest((String)url);
        request.method(method);
        request.agent("KosmoS Client");
        return request;
    }

    public void disconnect() {
        this.stopped = true;
        this.endpoint.stop();
    }

    public JSONObject getVars() {
        return this.endpoint.getVars();
    }

    public String getBase() {
        return this.base;
    }

    public String getPass() {
        return this.pass;
    }

    private ContentResponse getResponse(Request request) {
        ContentResponse response = null;
        try {
            response = request.send();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return response;
    }

    public String getToken() {
        return this.token;
    }

    public Object getVar(String key) {
        return this.endpoint.getVar(key);
    }

    public void setToken(String access_token) {
        this.token = access_token;
    }

    public String getUser() {
        return this.user;
    }

    public WebSocketClientEndpoint getWebSocket() {
        return this.endpoint;
    }

    public String post(String url, HashMap<String, Object> parameters) {
        Request request = this.createRequest(url, HttpMethod.POST);
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            multiPart.addFieldPart(entry.getKey(), (ContentProvider)new StringContentProvider(entry.getValue().toString()), null);
        }
        request.content((ContentProvider)multiPart);
        return this.getResponse(request).getContentAsString();
    }

    public JSONObject postJSON(String url, JSONObject json) {
        ContentResponse r;
        Request request = this.createRequest(url, HttpMethod.POST);
        if (json != null) {
            request.content((ContentProvider)new StringContentProvider(json.toString()), "application/json");
        }
        if (this.token != null) {
            request.header("authorization", "Bearer " + this.token);
        }
        if ((r = this.getResponse(request)) != null) {
            try {
                return new JSONObject(r.getContentAsString());
            }
            catch (JSONException ex) {
                logger.error("HTTP Status {}:{}", (Object)r.getStatus(), (Object)r.getContentAsString());
                logger.error("Exception", (Throwable)ex);
            }
        }
        return null;
    }

    public void sendCommand(JSONObject command, WebSocketEventConsumer consumer) {
        if (this.endpoint != null) {
            this.endpoint.sendCommand(command, consumer);
        } else {
            logger.error("NO ENDPOINT!!");
        }
    }

    public void unstop() {
        this.stopped = false;
    }

    public boolean waitForValue(String key, Object expected, long waittime) {
        return this.endpoint.waitForValue(key, expected, waittime);
    }

    public void waitForInit() throws InterruptedException {
        this.endpoint.initLatch.await();
    }

    public void addMessageHandler(String message, SimpleWebSocketEndpoint.MessageHandler messageHandler) {
        Queue<SimpleWebSocketEndpoint.MessageHandler> list = this.mapMessageHandler.get(message);
        if (list == null) {
            list = new ConcurrentLinkedQueue<SimpleWebSocketEndpoint.MessageHandler>();
            this.mapMessageHandler.put(message, list);
        }
        list.add(messageHandler);
    }

    public void addMessageHandler(Pattern message, SimpleWebSocketEndpoint.RegexMessageHandler messageHandler) {
        Queue<SimpleWebSocketEndpoint.RegexMessageHandler> list = this.mapRegexMessageHandler.get(message);
        if (list == null) {
            list = new ConcurrentLinkedQueue<SimpleWebSocketEndpoint.RegexMessageHandler>();
            this.mapRegexMessageHandler.put(message, list);
        }
        list.add(messageHandler);
    }
}

