/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.tools;

import java.util.List;
import us.ihmc.euclid.geometry.LineSegment1D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Triangle3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class EuclidGeometryIOTools {
    private EuclidGeometryIOTools() {
    }

    public static String getLine2DString(Line2DReadOnly line2D) {
        return EuclidGeometryIOTools.getLine2DString(EuclidCoreIOTools.DEFAULT_FORMAT, line2D);
    }

    public static String getLine2DString(String format, Line2DReadOnly line2D) {
        if (line2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getLine2DString(format, line2D.getPoint(), (Vector2DReadOnly)line2D.getDirection());
    }

    public static String getLine2DString(String format, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return "Line 2D: point = " + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)pointOnLine) + ", direction = " + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)lineDirection);
    }

    public static String getLine3DString(Line3DReadOnly line3D) {
        return EuclidGeometryIOTools.getLine3DString(EuclidCoreIOTools.DEFAULT_FORMAT, line3D);
    }

    public static String getLine3DString(String format, Line3DReadOnly line3D) {
        if (line3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getLine3DString(format, line3D.getPoint(), (Vector3DReadOnly)line3D.getDirection());
    }

    public static String getLine3DString(String format, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        return "Line 3D: point = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)pointOnLine) + ", direction = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)lineDirection);
    }

    public static String getLineSegment1DString(LineSegment1D lineSegment1D) {
        return EuclidGeometryIOTools.getLineSegment1DString(EuclidCoreIOTools.DEFAULT_FORMAT, lineSegment1D);
    }

    public static String getLineSegment1DString(String format, LineSegment1D lineSegment1D) {
        if (lineSegment1D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getLineSegment1DString(format, lineSegment1D.getFirstEndpoint(), lineSegment1D.getSecondEndpoint());
    }

    public static String getLineSegment1DString(String format, double lineSegmentStart, double lineSegmentEnd) {
        return "Line segment 1D: 1st endpoint = " + EuclidCoreIOTools.getStringOf((String)"(", (String)" )", (String)", ", (String)format, (double[])new double[]{lineSegmentStart}) + ", 2nd endpoint = " + EuclidCoreIOTools.getStringOf((String)"(", (String)" )", (String)", ", (String)format, (double[])new double[]{lineSegmentEnd});
    }

    public static String getLineSegment2DString(LineSegment2DReadOnly lineSegment2D) {
        return EuclidGeometryIOTools.getLineSegment2DString(EuclidCoreIOTools.DEFAULT_FORMAT, lineSegment2D);
    }

    public static String getLineSegment2DString(String format, LineSegment2DReadOnly lineSegment2D) {
        if (lineSegment2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getLineSegment2DString(format, lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint());
    }

    public static String getLineSegment2DString(String format, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return "Line segment 2D: 1st endpoint = " + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)lineSegmentStart) + ", 2nd endpoint = " + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)lineSegmentEnd);
    }

    public static String getLineSegment3DString(LineSegment3DReadOnly lineSegment3D) {
        return EuclidGeometryIOTools.getLineSegment3DString(EuclidCoreIOTools.DEFAULT_FORMAT, lineSegment3D);
    }

    public static String getLineSegment3DString(String format, LineSegment3DReadOnly lineSegment3D) {
        if (lineSegment3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getLineSegment3DString(format, lineSegment3D.getFirstEndpoint(), lineSegment3D.getSecondEndpoint());
    }

    public static String getLineSegment3DString(String format, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        return "Line segment 3D: 1st endpoint = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)lineSegmentStart) + ", 2nd endpoint = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)lineSegmentEnd);
    }

    public static String getBoundingBox2DString(BoundingBox2DReadOnly boundingBox2D) {
        return EuclidGeometryIOTools.getBoundingBox2DString(EuclidCoreIOTools.DEFAULT_FORMAT, boundingBox2D);
    }

    public static String getBoundingBox2DString(String format, BoundingBox2DReadOnly boundingBox2D) {
        if (boundingBox2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getBoundingBox2DString(format, boundingBox2D.getMinPoint(), boundingBox2D.getMaxPoint());
    }

    public static String getBoundingBox2DString(String format, Point2DReadOnly boundingBoxMin, Point2DReadOnly boundingBoxMax) {
        return "Bounding Box 2D: min = " + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)boundingBoxMin) + ", max = " + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)boundingBoxMax);
    }

    public static String getBoundingBox3DString(BoundingBox3DReadOnly boundingBox3D) {
        return EuclidGeometryIOTools.getBoundingBox3DString(EuclidCoreIOTools.DEFAULT_FORMAT, boundingBox3D);
    }

    public static String getBoundingBox3DString(String format, BoundingBox3DReadOnly boundingBox3D) {
        if (boundingBox3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getBoundingBox3DString(format, boundingBox3D.getMinPoint(), boundingBox3D.getMaxPoint());
    }

    public static String getBoundingBox3DString(String format, Point3DReadOnly boundingBoxMin, Point3DReadOnly boundingBoxMax) {
        return "Bounding Box 3D: min = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)boundingBoxMin) + ", max = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)boundingBoxMax);
    }

    @Deprecated
    public static String getOrientation2DString(Orientation2DReadOnly orientation2D) {
        return EuclidCoreIOTools.getOrientation2DString((Orientation2DReadOnly)orientation2D);
    }

    @Deprecated
    public static String getOrientation2DString(String format, Orientation2DReadOnly orientation2D) {
        return EuclidCoreIOTools.getOrientation2DString((String)format, (Orientation2DReadOnly)orientation2D);
    }

    @Deprecated
    public static String getOrientation2DString(String format, double orientation2DAngle) {
        return EuclidCoreIOTools.getOrientation2DString((String)format, (double)orientation2DAngle);
    }

    public static String getPlane3DString(Plane3D plane3D) {
        return EuclidGeometryIOTools.getPlane3DString(EuclidCoreIOTools.DEFAULT_FORMAT, plane3D);
    }

    public static String getPlane3DString(String format, Plane3D plane3D) {
        if (plane3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getPlane3DString(format, (Point3DReadOnly)plane3D.getPoint(), (Vector3DReadOnly)plane3D.getNormal());
    }

    public static String getPlane3DString(String format, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return "Plane 3D: point = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)pointOnPlane) + ", normal = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)planeNormal);
    }

    public static String getPose2DString(Pose2DReadOnly pose2D) {
        return EuclidGeometryIOTools.getPose2DString(EuclidCoreIOTools.DEFAULT_FORMAT, pose2D);
    }

    public static String getPose2DString(String format, Pose2DReadOnly pose2D) {
        if (pose2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getPose2DString(format, pose2D.getPosition(), pose2D.getYaw());
    }

    public static String getPose2DString(String format, Point2DReadOnly position, double orientation) {
        return "Pose 2D: position = " + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)position) + ", orientation = " + EuclidGeometryIOTools.getOrientation2DString(format, orientation);
    }

    public static String getPose3DString(Pose3DReadOnly pose3D) {
        return EuclidGeometryIOTools.getPose3DString(EuclidCoreIOTools.DEFAULT_FORMAT, pose3D);
    }

    public static String getPose3DString(String format, Pose3DReadOnly pose3D) {
        if (pose3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getPose3DString(format, pose3D.getPosition(), pose3D.getOrientation());
    }

    public static String getPose3DString(String format, Point3DReadOnly position, QuaternionReadOnly orientation) {
        return "Pose 3D: position = " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)position) + ", orientation = " + EuclidCoreIOTools.getTuple4DString((String)format, (Tuple4DReadOnly)orientation);
    }

    public static String getConvexPolygon2DString(ConvexPolygon2DReadOnly convexPolygon2D) {
        return EuclidGeometryIOTools.getConvexPolygon2DString(EuclidCoreIOTools.DEFAULT_FORMAT, convexPolygon2D);
    }

    public static String getConvexPolygon2DString(String format, ConvexPolygon2DReadOnly convexPolygon2D) {
        if (convexPolygon2D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getConvexPolygon2DString(format, convexPolygon2D.getPolygonVerticesView(), convexPolygon2D.getNumberOfVertices());
    }

    public static String getConvexPolygon2DString(String format, List<? extends Point2DReadOnly> vertices, int numberOfVertices) {
        if (numberOfVertices == 0) {
            return "Convex Polygon 2D: vertices = []";
        }
        String string = "Convex Polygon 2D: vertices = [\n";
        for (int i = 0; i < numberOfVertices - 1; ++i) {
            string = string + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)((Tuple2DReadOnly)vertices.get(i))) + ",\n";
        }
        string = string + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)((Tuple2DReadOnly)vertices.get(numberOfVertices - 1))) + " ]";
        return string;
    }

    public static String getTriangle3DString(Triangle3DReadOnly triangle3D) {
        return EuclidGeometryIOTools.getTriangle3DString(EuclidCoreIOTools.DEFAULT_FORMAT, triangle3D);
    }

    public static String getTriangle3DString(String format, Triangle3DReadOnly triangle3D) {
        if (triangle3D == null) {
            return "null";
        }
        return EuclidGeometryIOTools.getTriangle3DString(format, triangle3D.getA(), triangle3D.getB(), triangle3D.getC());
    }

    public static String getTriangle3DString(String format, Point3DReadOnly a, Point3DReadOnly b, Point3DReadOnly c) {
        return "Triangle 3D: [" + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)a) + ", " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)b) + ", " + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)c) + "]";
    }

    public static String getVertex2DSupplierString(Vertex2DSupplier vertex2DSupplier) {
        return EuclidGeometryIOTools.getVertex2DSupplierString(EuclidCoreIOTools.DEFAULT_FORMAT, vertex2DSupplier);
    }

    public static String getVertex2DSupplierString(String format, Vertex2DSupplier vertex2DSupplier) {
        if (vertex2DSupplier == null) {
            return "null";
        }
        if (vertex2DSupplier.getNumberOfVertices() == 0) {
            return "Vertex 2D supplier: vertices = []";
        }
        String string = "Vertex 2D supplier: vertices = [\n";
        for (int i = 0; i < vertex2DSupplier.getNumberOfVertices() - 1; ++i) {
            string = string + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)vertex2DSupplier.getVertex(i)) + ",\n";
        }
        string = string + EuclidCoreIOTools.getTuple2DString((String)format, (Tuple2DReadOnly)vertex2DSupplier.getVertex(vertex2DSupplier.getNumberOfVertices() - 1)) + " ]";
        return string;
    }

    public static String getVertex3DSupplierString(Vertex3DSupplier vertex3DSupplier) {
        return EuclidGeometryIOTools.getVertex3DSupplierString(EuclidCoreIOTools.DEFAULT_FORMAT, vertex3DSupplier);
    }

    public static String getVertex3DSupplierString(String format, Vertex3DSupplier vertex3DSupplier) {
        if (vertex3DSupplier == null) {
            return "null";
        }
        if (vertex3DSupplier.getNumberOfVertices() == 0) {
            return "Vertex 3D supplier: vertices = []";
        }
        String string = "Vertex 3D supplier: vertices = [\n";
        for (int i = 0; i < vertex3DSupplier.getNumberOfVertices() - 1; ++i) {
            string = string + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)vertex3DSupplier.getVertex(i)) + ",\n";
        }
        string = string + EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)vertex3DSupplier.getVertex(vertex3DSupplier.getNumberOfVertices() - 1)) + " ]";
        return string;
    }
}

