/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Plane3DBasics
extends Plane3DReadOnly,
Clearable,
Transformable {
    public Point3DBasics getPoint();

    public UnitVector3DBasics getNormal();

    @Override
    default public boolean containsNaN() {
        return Plane3DReadOnly.super.containsNaN();
    }

    default public void setToNaN() {
        this.getPoint().setToNaN();
        this.getNormal().setToNaN();
    }

    default public void setToZero() {
        this.getPoint().setToZero();
        this.getNormal().set((UnitVector3DReadOnly)Axis3D.Z);
    }

    default public void set(double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeNormalX, double planeNormalY, double planeNormalZ) {
        this.getPoint().set(pointOnPlaneX, pointOnPlaneY, pointOnPlaneZ);
        this.getNormal().set(planeNormalX, planeNormalY, planeNormalZ);
    }

    default public void set(Plane3DReadOnly other) {
        this.getPoint().set((Tuple3DReadOnly)other.getPoint());
        this.getNormal().set(other.getNormal());
    }

    default public boolean set(Point3DReadOnly firstPointOnPlane, Point3DReadOnly secondPointOnPlane, Point3DReadOnly thirdPointOnPlane) {
        this.getPoint().set((Tuple3DReadOnly)firstPointOnPlane);
        return EuclidGeometryTools.normal3DFromThreePoint3Ds(firstPointOnPlane, secondPointOnPlane, thirdPointOnPlane, (Vector3DBasics)this.getNormal());
    }

    default public void set(Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        this.getPoint().set((Tuple3DReadOnly)pointOnPlane);
        this.getNormal().set((Tuple3DReadOnly)planeNormal);
    }

    default public void applyTransform(Transform transform) {
        this.getPoint().applyTransform(transform);
        this.getNormal().applyTransform(transform);
    }

    default public void applyInverseTransform(Transform transform) {
        this.getPoint().applyInverseTransform(transform);
        this.getNormal().applyInverseTransform(transform);
    }
}

