/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface LineSegment3DBasics
extends LineSegment3DReadOnly,
Clearable,
Transformable {
    public Point3DBasics getFirstEndpoint();

    public Point3DBasics getSecondEndpoint();

    default public boolean containsNaN() {
        return this.getFirstEndpoint().containsNaN() || this.getSecondEndpoint().containsNaN();
    }

    default public void setToZero() {
        this.getFirstEndpoint().setToZero();
        this.getSecondEndpoint().setToZero();
    }

    default public void setToNaN() {
        this.getFirstEndpoint().setToNaN();
        this.getSecondEndpoint().setToNaN();
    }

    @Deprecated
    default public void setFirstEndpoint(double firstEndpointX, double firstEndpointY, double firstEndpointZ) {
        this.getFirstEndpoint().set(firstEndpointX, firstEndpointY, firstEndpointZ);
    }

    @Deprecated
    default public void setSecondEndpoint(double secondEndpointX, double secondEndpointY, double secondEndpointZ) {
        this.getSecondEndpoint().set(secondEndpointX, secondEndpointY, secondEndpointZ);
    }

    @Deprecated
    default public void setFirstEndpoint(Point3DReadOnly firstEndpoint) {
        this.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
    }

    @Deprecated
    default public void setSecondEndpoint(Point3DReadOnly secondEndpoint) {
        this.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
    }

    default public void set(LineSegment3DReadOnly other) {
        this.set(other.getFirstEndpoint(), other.getSecondEndpoint());
    }

    default public void set(double firstEndpointX, double firstEndpointY, double firstEndpointZ, double secondEndpointX, double secondEndpointY, double secondEndpointZ) {
        this.getFirstEndpoint().set(firstEndpointX, firstEndpointY, firstEndpointZ);
        this.getSecondEndpoint().set(secondEndpointX, secondEndpointY, secondEndpointZ);
    }

    default public void set(Point3DReadOnly firstEndpoint, Point3DReadOnly secondEndpoint) {
        this.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
        this.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
    }

    default public void set(Point3DReadOnly firstEndpoint, Vector3DReadOnly fromFirstToSecondEndpoint) {
        this.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
        this.getSecondEndpoint().add((Tuple3DReadOnly)firstEndpoint, (Tuple3DReadOnly)fromFirstToSecondEndpoint);
    }

    default public void flipDirection() {
        double x = this.getFirstEndpointX();
        double y = this.getFirstEndpointY();
        double z = this.getFirstEndpointZ();
        this.getFirstEndpoint().set((Tuple3DReadOnly)this.getSecondEndpoint());
        this.getSecondEndpoint().set(x, y, z);
    }

    default public void translate(double x, double y, double z) {
        this.getFirstEndpoint().add(x, y, z);
        this.getSecondEndpoint().add(x, y, z);
    }

    default public void translate(Tuple3DReadOnly translation) {
        this.translate(translation.getX(), translation.getY(), translation.getZ());
    }

    default public void applyTransform(Transform transform) {
        this.getFirstEndpoint().applyTransform(transform);
        this.getSecondEndpoint().applyTransform(transform);
    }

    default public void applyInverseTransform(Transform transform) {
        this.getFirstEndpoint().applyInverseTransform(transform);
        this.getSecondEndpoint().applyInverseTransform(transform);
    }
}

