/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DBasics;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public interface Line2DReadOnly {
    public Point2DReadOnly getPoint();

    public UnitVector2DReadOnly getDirection();

    default public double getDirectionX() {
        return this.getDirection().getX();
    }

    default public double getDirectionY() {
        return this.getDirection().getY();
    }

    default public void get(Point2DBasics pointToPack, Vector2DBasics directionToPack) {
        pointToPack.set((Tuple2DReadOnly)this.getPoint());
        directionToPack.set((Tuple2DReadOnly)this.getDirection());
    }

    default public double getPointX() {
        return this.getPoint().getX();
    }

    default public double getPointY() {
        return this.getPoint().getY();
    }

    default public double distance(Point2DReadOnly point) {
        return EuclidGeometryTools.distanceFromPoint2DToLine2D(point, this.getPoint(), (Vector2DReadOnly)this.getDirection());
    }

    default public Point2DBasics[] intersectionWith(ConvexPolygon2DReadOnly convexPolygon) {
        return convexPolygon.intersectionWith(this);
    }

    default public int intersectionWith(ConvexPolygon2DReadOnly convexPolygon, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return convexPolygon.intersectionWith(this, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public Point2DBasics intersectionWith(Line2DReadOnly secondLine) {
        return EuclidGeometryTools.intersectionBetweenTwoLine2Ds(this.getPoint(), (Vector2DReadOnly)this.getDirection(), secondLine.getPoint(), (Vector2DReadOnly)secondLine.getDirection());
    }

    default public boolean intersectionWith(Line2DReadOnly secondLine, Point2DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenTwoLine2Ds(this.getPoint(), (Vector2DReadOnly)this.getDirection(), secondLine.getPoint(), (Vector2DReadOnly)secondLine.getDirection(), intersectionToPack);
    }

    default public Point2DBasics intersectionWith(LineSegment2DReadOnly lineSegment) {
        return EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D(this.getPoint(), (Vector2DReadOnly)this.getDirection(), lineSegment.getFirstEndpoint(), lineSegment.getSecondEndpoint());
    }

    default public boolean intersectionWith(LineSegment2DReadOnly lineSegment, Point2DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D(this.getPoint(), (Vector2DReadOnly)this.getDirection(), lineSegment.getFirstEndpoint(), lineSegment.getSecondEndpoint(), intersectionToPack);
    }

    default public boolean isPointBehindLine(Point2DReadOnly point) {
        return !this.isPointInFrontOfLine(point);
    }

    default public boolean isPointInFrontOfLine(Point2DReadOnly point) {
        if (this.getDirectionY() > 0.0) {
            return this.isPointOnRightSideOfLine(point);
        }
        if (this.getDirectionY() < 0.0) {
            return this.isPointOnLeftSideOfLine(point);
        }
        throw new RuntimeException("Not defined when line is pointing exactly along the x-axis");
    }

    default public boolean isPointInFrontOfLine(Vector2DReadOnly frontDirection, Point2DReadOnly point) {
        double crossProduct = frontDirection.cross((Tuple2DReadOnly)this.getDirection());
        if (crossProduct > 0.0) {
            return this.isPointOnRightSideOfLine(point);
        }
        if (crossProduct < 0.0) {
            return this.isPointOnLeftSideOfLine(point);
        }
        throw new RuntimeException("Not defined when line is pointing exactly along the front direction");
    }

    default public boolean isPointOnLeftSideOfLine(Point2DReadOnly point) {
        return this.isPointOnSideOfLine(point, true);
    }

    default public boolean isPointOnLine(Point2DReadOnly point) {
        return this.isPointOnLine(point, 1.0E-8);
    }

    default public boolean isPointOnLine(Point2DReadOnly point, double epsilon) {
        return EuclidGeometryTools.distanceFromPoint2DToLine2D(point, this.getPoint(), (Vector2DReadOnly)this.getDirection()) < epsilon;
    }

    default public boolean isPointOnRightSideOfLine(Point2DReadOnly point) {
        return this.isPointOnSideOfLine(point, false);
    }

    default public boolean isPointOnSideOfLine(double pointX, double pointY, boolean testLeftSide) {
        return EuclidGeometryTools.isPoint2DOnSideOfLine2D(pointX, pointY, this.getPoint(), (Vector2DReadOnly)this.getDirection(), testLeftSide);
    }

    default public boolean isPointOnSideOfLine(Point2DReadOnly point, boolean testLeftSide) {
        return EuclidGeometryTools.isPoint2DOnSideOfLine2D(point, this.getPoint(), (Vector2DReadOnly)this.getDirection(), testLeftSide);
    }

    default public boolean orthogonalProjection(Point2DBasics pointToProject) {
        return this.orthogonalProjection((Point2DReadOnly)pointToProject, pointToProject);
    }

    default public boolean orthogonalProjection(Point2DReadOnly pointToProject, Point2DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLine2D(pointToProject, this.getPoint(), (Vector2DReadOnly)this.getDirection(), projectionToPack);
    }

    default public Point2DBasics orthogonalProjectionCopy(Point2DReadOnly pointToProject) {
        return EuclidGeometryTools.orthogonalProjectionOnLine2D(pointToProject, this.getPoint(), (Vector2DReadOnly)this.getDirection());
    }

    default public double parameterGivenPointOnLine(Point2DReadOnly pointOnLine, double epsilon) {
        if (!this.isPointOnLine(pointOnLine, epsilon)) {
            throw new RuntimeException("The given point is not on this line, distance from line: " + this.distance(pointOnLine));
        }
        double x0 = this.getPointX();
        double y0 = this.getPointY();
        double x1 = x0 + this.getDirectionX();
        double y1 = y0 + this.getDirectionY();
        return EuclidGeometryTools.percentageAlongLineSegment2D(pointOnLine.getX(), pointOnLine.getY(), x0, y0, x1, y1);
    }

    default public Line2DBasics perpendicularLineThroughPoint(Point2DReadOnly point) {
        return new Line2D(point, (Vector2DReadOnly)this.perpendicularVector());
    }

    default public void perpendicularLineThroughPoint(Point2DReadOnly point, Line2DBasics perpendicularLineToPack) {
        perpendicularLineToPack.set(point.getX(), point.getY(), -this.getDirection().getY(), this.getDirection().getX());
    }

    default public Vector2DBasics perpendicularVector() {
        return EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)this.getDirection());
    }

    default public void perpendicularVector(Vector2DBasics vectorToPack) {
        EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)this.getDirection(), vectorToPack);
    }

    default public Point2DBasics pointOnLineGivenParameter(double t) {
        Point2D pointToReturn = new Point2D();
        this.pointOnLineGivenParameter(t, (Point2DBasics)pointToReturn);
        return pointToReturn;
    }

    default public void pointOnLineGivenParameter(double t, Point2DBasics pointToPack) {
        pointToPack.scaleAdd(t, (Tuple2DReadOnly)this.getDirection(), (Tuple2DReadOnly)this.getPoint());
    }

    default public void getTwoPointsOnLine(Point2DBasics firstPointOnLineToPack, Point2DBasics secondPointOnLineToPack) {
        firstPointOnLineToPack.set((Tuple2DReadOnly)this.getPoint());
        secondPointOnLineToPack.add((Tuple2DReadOnly)this.getPoint(), (Tuple2DReadOnly)this.getDirection());
    }

    default public Line2DBasics interiorBisector(Line2DReadOnly secondLine) {
        Line2D interiorBisector = new Line2D();
        boolean success = this.interiorBisector(secondLine, interiorBisector);
        return success ? interiorBisector : null;
    }

    default public boolean interiorBisector(Line2DReadOnly secondLine, Line2DBasics interiorBisectorToPack) {
        double t = EuclidGeometryTools.percentageOfIntersectionBetweenTwoLine2Ds(this.getPoint(), (Vector2DReadOnly)this.getDirection(), secondLine.getPoint(), (Vector2DReadOnly)secondLine.getDirection());
        if (Double.isNaN(t)) {
            return false;
        }
        if (Double.isInfinite(t)) {
            interiorBisectorToPack.set(this);
            return true;
        }
        double pointOnBisectorX = t * this.getDirectionX() + this.getPointX();
        double pointOnBisectorY = t * this.getDirectionY() + this.getPointY();
        double bisectorDirectionX = this.getDirectionX() + secondLine.getDirectionX();
        double bisectorDirectionY = this.getDirectionY() + secondLine.getDirectionY();
        interiorBisectorToPack.set(pointOnBisectorX, pointOnBisectorY, bisectorDirectionX, bisectorDirectionY);
        return true;
    }

    default public double xIntercept() {
        double parameterAtIntercept = -this.getPointY() / this.getDirectionY();
        return parameterAtIntercept * this.getDirectionX() + this.getPointX();
    }

    default public double yIntercept() {
        double parameterAtIntercept = -this.getPointX() / this.getDirectionX();
        return parameterAtIntercept * this.getDirectionY() + this.getPointY();
    }

    default public double slope() {
        if (this.getDirectionX() == 0.0 && this.getDirectionY() > 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.getDirectionX() == 0.0 && this.getDirectionY() < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.getDirectionY() / this.getDirectionX();
    }

    default public boolean isCollinear(Line2DReadOnly other, double epsilon) {
        return this.isCollinear(other, epsilon, epsilon);
    }

    default public boolean isCollinear(Line2DReadOnly other, double angleEpsilon, double distanceEpsilon) {
        return EuclidGeometryTools.areLine2DsCollinear(this.getPoint(), (Vector2DReadOnly)this.getDirection(), other.getPoint(), (Vector2DReadOnly)other.getDirection(), angleEpsilon, distanceEpsilon);
    }

    default public boolean areLinesPerpendicular(Line2DReadOnly other) {
        return this.getDirection().dot((Vector2DReadOnly)other.getDirection()) < 1.0E-7;
    }

    default public boolean epsilonEquals(Line2DReadOnly other, double epsilon) {
        if (!this.getPoint().epsilonEquals((Tuple2DReadOnly)other.getPoint(), epsilon)) {
            return false;
        }
        return this.getDirection().epsilonEquals((Tuple2DReadOnly)other.getDirection(), epsilon);
    }

    default public boolean geometricallyEquals(Line2DReadOnly other, double epsilon) {
        return this.isCollinear(other, epsilon);
    }

    default public boolean equals(Line2DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getPoint().equals((Tuple2DReadOnly)other.getPoint()) && this.getDirection().equals((Tuple2DReadOnly)other.getDirection());
    }
}

