/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.nut;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import net.bramp.ffmpeg.nut.Frame;
import net.bramp.ffmpeg.nut.StreamHeaderPacket;

public class RawHandler {
    private static int[] bytesToInts(byte[] bytes) {
        IntBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
        int[] data = new int[buf.capacity()];
        buf.get(data);
        return data;
    }

    public static BufferedImage toBufferedImage(Frame frame) {
        Preconditions.checkNotNull((Object)frame);
        StreamHeaderPacket header = frame.stream.header;
        Preconditions.checkArgument((header.type == 0L ? 1 : 0) != 0);
        int type = 2;
        BufferedImage img = new BufferedImage(header.width, header.height, type);
        int[] data = RawHandler.bytesToInts(frame.data);
        int stride = header.width;
        img.setRGB(0, 0, header.width, header.height, data, 0, stride);
        return img;
    }

    public static AudioFormat streamToAudioFormat(StreamHeaderPacket header) {
        AudioFormat.Encoding encoding;
        Preconditions.checkNotNull((Object)header);
        Preconditions.checkArgument((header.type == 1L ? 1 : 0) != 0);
        float sampleRate = header.sampleRate.floatValue();
        int bits = 8;
        boolean bigEndian = false;
        byte[] fourcc = header.fourcc;
        if (Arrays.equals(fourcc, new byte[]{65, 76, 65, 87})) {
            encoding = AudioFormat.Encoding.ALAW;
        } else if (Arrays.equals(fourcc, new byte[]{85, 76, 65, 87})) {
            encoding = AudioFormat.Encoding.ULAW;
        } else if (fourcc.length == 4) {
            byte interleaving;
            byte type;
            if (fourcc[0] == 80) {
                bigEndian = false;
                type = fourcc[1];
                interleaving = fourcc[2];
                bits = fourcc[3];
            } else if (fourcc[3] == 80) {
                bigEndian = true;
                type = fourcc[2];
                interleaving = fourcc[1];
                bits = fourcc[0];
            } else {
                throw new IllegalArgumentException("unknown fourcc value: '" + StreamHeaderPacket.fourccToString(fourcc) + "'");
            }
            if (interleaving != 68) {
                throw new IllegalArgumentException("unsupported interleaving '" + interleaving + "' in fourcc value '" + StreamHeaderPacket.fourccToString(fourcc) + "'");
            }
            switch (type) {
                case 83: {
                    encoding = AudioFormat.Encoding.PCM_SIGNED;
                    break;
                }
                case 85: {
                    encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    break;
                }
                case 70: {
                    encoding = AudioFormat.Encoding.PCM_FLOAT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown fourcc '" + StreamHeaderPacket.fourccToString(fourcc) + "' type: " + type);
                }
            }
        } else {
            throw new IllegalArgumentException("unknown fourcc value: '" + StreamHeaderPacket.fourccToString(fourcc) + "'");
        }
        int frameSize = bits * header.channels / 8;
        float frameRate = sampleRate;
        return new AudioFormat(encoding, sampleRate, bits, header.channels, frameSize, frameRate, bigEndian);
    }

    public static AudioInputStream toAudioInputStream(Frame frame) {
        Preconditions.checkNotNull((Object)frame);
        StreamHeaderPacket header = (StreamHeaderPacket)Preconditions.checkNotNull((Object)frame.stream.header);
        Preconditions.checkArgument((header.type == 1L ? 1 : 0) != 0);
        AudioFormat format = RawHandler.streamToAudioFormat(header);
        ByteArrayInputStream stream = new ByteArrayInputStream(frame.data);
        return new AudioInputStream(stream, format, frame.data.length / format.getFrameSize());
    }
}

