/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bramp.ffmpeg.FFcommon;
import net.bramp.ffmpeg.FFmpegUtils;
import net.bramp.ffmpeg.ProcessFunction;
import net.bramp.ffmpeg.RunProcessFunction;
import net.bramp.ffmpeg.io.LoggingFilterReader;
import net.bramp.ffmpeg.probe.FFmpegProbeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFprobe
extends FFcommon {
    static final Logger LOG = LoggerFactory.getLogger(FFprobe.class);
    static final String FFPROBE = "ffprobe";
    static final String DEFAULT_PATH = (String)MoreObjects.firstNonNull((Object)System.getenv("FFPROBE"), (Object)"ffprobe");
    static final Gson gson = FFmpegUtils.getGson();

    public FFprobe() throws IOException {
        this(DEFAULT_PATH, new RunProcessFunction());
    }

    public FFprobe(@Nonnull ProcessFunction runFunction) throws IOException {
        this(DEFAULT_PATH, runFunction);
    }

    public FFprobe(@Nonnull String path) throws IOException {
        this(path, new RunProcessFunction());
    }

    public FFprobe(@Nonnull String path, @Nonnull ProcessFunction runFunction) {
        super(path, runFunction);
    }

    public FFmpegProbeResult probe(String mediaPath) throws IOException {
        return this.probe(mediaPath, null);
    }

    public boolean isFFprobe() throws IOException {
        return this.version().startsWith(FFPROBE);
    }

    private void checkIfFFprobe() throws IllegalArgumentException, IOException {
        if (!this.isFFprobe()) {
            throw new IllegalArgumentException("This binary '" + this.path + "' is not a supported version of ffprobe");
        }
    }

    @Override
    public void run(List<String> args) throws IOException {
        this.checkIfFFprobe();
        super.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FFmpegProbeResult probe(String mediaPath, @Nullable String userAgent) throws IOException {
        this.checkIfFFprobe();
        ImmutableList.Builder args = new ImmutableList.Builder();
        args.add((Object)this.path).add((Object[])new String[]{"-v", "quiet"});
        if (userAgent != null) {
            args.add((Object[])new String[]{"-user-agent", userAgent});
        }
        args.add((Object[])new String[]{"-print_format", "json"}).add((Object)"-show_error").add((Object)"-show_format").add((Object)"-show_streams").add((Object)"-show_chapters").add((Object)mediaPath);
        Process p = this.runFunc.run((List<String>)args.build());
        try {
            Reader reader = this.wrapInReader(p);
            if (LOG.isDebugEnabled()) {
                reader = new LoggingFilterReader(reader, LOG);
            }
            FFmpegProbeResult result = (FFmpegProbeResult)gson.fromJson(reader, FFmpegProbeResult.class);
            this.throwOnError(p);
            if (result == null) {
                throw new IllegalStateException("Gson returned null, which shouldn't happen :(");
            }
            FFmpegProbeResult fFmpegProbeResult = result;
            return fFmpegProbeResult;
        }
        finally {
            p.destroy();
        }
    }
}

