/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ClassLoaderTools {
    private static final boolean DEBUG = false;
    private static PathMatcher classMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.class");

    public static void copyToFileSystem(final Path target, String ... directories) throws IOException {
        ClassLoaderTools.recursivelyGetResources(new ResourceHandler(){

            @Override
            public void handleResource(String resourcePath) throws IOException {
                InputStream resource = ClassLoaderTools.class.getClassLoader().getResourceAsStream(resourcePath);
                Path destination = target.resolve(resourcePath);
                Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                Files.copy(resource, destination, StandardCopyOption.REPLACE_EXISTING);
                resource.close();
            }
        }, directories);
    }

    public static void createZipBundle(OutputStream os, final Pattern exclude, String ... directories) throws IOException {
        final ZipOutputStream stream = new ZipOutputStream(os);
        ClassLoaderTools.recursivelyGetResources(new ResourceHandler(){
            private final HashSet<String> names = new HashSet();

            @Override
            public void handleResource(String resourcePath) throws IOException {
                if (exclude != null && exclude.matcher(resourcePath).matches()) {
                    return;
                }
                ZipEntry entry = new ZipEntry(resourcePath);
                if (this.names.add(entry.getName())) {
                    InputStream resource = ClassLoaderTools.class.getClassLoader().getResourceAsStream(resourcePath);
                    stream.putNextEntry(entry);
                    ClassLoaderTools.copyStream(resource, stream);
                    stream.closeEntry();
                    resource.close();
                }
            }
        }, directories);
        stream.close();
    }

    public static void createZipBundle(OutputStream os, String ... directories) throws IOException {
        ClassLoaderTools.createZipBundle(os, null, directories);
    }

    @Deprecated
    public static void addURLToSystemClassLoader(URL url) throws IOException {
        URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> classLoaderClass = URLClassLoader.class;
        try {
            Method method = classLoaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)systemClassLoader, url);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error when adding url to system ClassLoader ");
        }
    }

    private static List<Path> getTopLevelDirectories(Path ... directories) {
        ArrayList<Path> topLevelDirectories = new ArrayList<Path>();
        for (Path directory : directories) {
            if (!ClassLoaderTools.isTopLevelDirectory(directory, directories)) continue;
            topLevelDirectories.add(directory);
        }
        return topLevelDirectories;
    }

    private static boolean isTopLevelDirectory(Path directory, Path ... directories) {
        if (Files.exists(directory, new LinkOption[0])) {
            for (Path testDirectory : directories) {
                if (directory.equals(testDirectory) || !directory.startsWith(testDirectory)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static void printIfDebug(String string) {
    }

    private static void recursivelyGetResources(final ResourceHandler resourceHandler, String ... directories) throws IOException {
        HashSet<String> classPathSet = new HashSet<String>();
        Enumeration<URL> manifests = ClassLoaderTools.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (manifests.hasMoreElements()) {
            URL next = manifests.nextElement();
            InputStream stream = next.openStream();
            Manifest manifest = new Manifest(stream);
            String jarClassPath = manifest.getMainAttributes().getValue("Class-Path");
            if (jarClassPath != null) {
                classPathSet.addAll(Arrays.asList(jarClassPath.split(" ")));
            }
            stream.close();
        }
        classPathSet.addAll(Arrays.asList(System.getProperty("java.class.path").split(Pattern.quote(File.pathSeparator))));
        for (String nextToken : classPathSet) {
            Path path;
            FileSystem fs;
            Path classPath = null;
            try {
                classPath = Paths.get(nextToken, new String[0]);
            }
            catch (InvalidPathException e) {
                ClassLoaderTools.printIfDebug("Couldn't find " + nextToken);
                continue;
            }
            if (!Files.exists(classPath, new LinkOption[0])) continue;
            if (!Files.isDirectory(classPath, new LinkOption[0])) {
                try {
                    fs = FileSystems.newFileSystem(classPath, null);
                }
                catch (Exception e) {
                    continue;
                }
                path = fs.getPath("/", new String[0]);
            } else {
                fs = null;
                path = classPath;
            }
            Path[] absoluteDirectories = new Path[directories.length];
            for (int i = 0; i < directories.length; ++i) {
                absoluteDirectories[i] = path.resolve(directories[i]);
            }
            for (Path subdir : ClassLoaderTools.getTopLevelDirectories(absoluteDirectories)) {
                if (!Files.exists(subdir, new LinkOption[0])) continue;
                Files.walkFileTree(subdir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!classMatcher.matches(file)) {
                            resourceHandler.handleResource(path.relativize(file).toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            if (fs == null) continue;
            fs.close();
        }
    }

    private static void copyStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
    }

    private static interface ResourceHandler {
        public void handleResource(String var1) throws IOException;
    }
}

