/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.realtime;

import us.ihmc.realtime.RealtimeNative;

public class PriorityParameters {
    private static final int maximumPriority = RealtimeNative.getMaximumPriorityNative();
    private static final int minimumPriority = RealtimeNative.getMinimumPriorityNative();
    public static final PriorityParameters MAXIMUM_PRIORITY = new PriorityParameters(maximumPriority);
    public static final PriorityParameters MINIMUM_PRIORITY = new PriorityParameters(minimumPriority);
    private final int priority;

    public PriorityParameters(int priority) {
        if (minimumPriority > priority || priority > maximumPriority) {
            throw new RuntimeException("Unsupported priority, requested " + priority + ", minimum: " + minimumPriority + "; maximum: " + maximumPriority);
        }
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public static int getMaximumPriority() {
        return maximumPriority;
    }

    public static int getMinimumPriority() {
        return minimumPriority;
    }

    public static PriorityParameters getRelativePriority(int relativePriority) {
        if (relativePriority < 0 || relativePriority > 100) {
            throw new RuntimeException("The relative priority needs to be in the range from 0 to 100");
        }
        int priorityRange = maximumPriority - minimumPriority;
        int absolutePriority = minimumPriority + priorityRange * relativePriority / 100;
        return new PriorityParameters(absolutePriority);
    }
}

