/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.nativelibraries;

public class NativeLibraryWithDependencies {
    private final String libraryFilename;
    private final String[] dependencyFilenames;

    private NativeLibraryWithDependencies(String libraryFilename, String ... dependencyFilenames) {
        this.libraryFilename = libraryFilename;
        this.dependencyFilenames = dependencyFilenames;
    }

    public String getLibraryFilename() {
        return this.libraryFilename;
    }

    public String[] getDependencyFilenames() {
        return this.dependencyFilenames;
    }

    public static String getPlatformName(String libraryName) {
        return System.mapLibraryName(libraryName).replace(".jnilib", ".dylib");
    }

    public static NativeLibraryWithDependencies fromPlatform(String libraryName, String ... dependencies) {
        String[] platformDependencies;
        if (dependencies != null) {
            platformDependencies = new String[dependencies.length];
            for (int i = 0; i < dependencies.length; ++i) {
                platformDependencies[i] = NativeLibraryWithDependencies.getPlatformName(dependencies[i]);
            }
        } else {
            platformDependencies = null;
        }
        return new NativeLibraryWithDependencies(NativeLibraryWithDependencies.getPlatformName(libraryName), platformDependencies);
    }

    public static NativeLibraryWithDependencies fromFilename(String libraryFile, String ... dependencyFiles) {
        return new NativeLibraryWithDependencies(libraryFile, dependencyFiles);
    }
}

