/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.nativelibraries;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.ArchUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.arch.Processor;
import us.ihmc.tools.nativelibraries.DefaultNativeLibraryDescription;
import us.ihmc.tools.nativelibraries.NativeLibraryDescription;
import us.ihmc.tools.nativelibraries.NativeLibraryWithDependencies;

public class NativeLibraryLoader {
    public static final String LIBRARY_LOCATION = new File(System.getProperty("user.home"), ".ihmc" + File.separator + "lib").getAbsolutePath();
    private static final HashMap<String, List<String>> extractedLibraries = new HashMap();
    private static final HashSet<String> loadedLibraries = new HashSet();

    private NativeLibraryLoader() {
    }

    public static void loadLibrary(String packageName, String libraryName) {
        if (!NativeLibraryLoader.loadLibrary(new DefaultNativeLibraryDescription(packageName, libraryName))) {
            throw new UnsatisfiedLinkError("Cannot load " + NativeLibraryLoader.createPackagePrefix(packageName) + libraryName);
        }
    }

    public static String extractLibrary(String packageName, String libraryName) {
        return NativeLibraryLoader.extractLibraryWithDependenciesAbsolute(packageName, NativeLibraryWithDependencies.fromPlatform(libraryName, new String[0])).get(0);
    }

    public static String extractLibraries(String packageName, String mainLibrary, String ... libraries) {
        NativeLibraryWithDependencies library = NativeLibraryWithDependencies.fromPlatform(mainLibrary, libraries);
        List<String> extracted = NativeLibraryLoader.extractLibraryWithDependenciesAbsolute(packageName, library);
        return extracted.get(0);
    }

    @Deprecated
    public static String extractLibraryAbsolute(String packageName, String library) {
        NativeLibraryWithDependencies libraryWithDependencies = NativeLibraryWithDependencies.fromFilename(library, new String[0]);
        return NativeLibraryLoader.extractLibraryWithDependenciesAbsolute(packageName, libraryWithDependencies).get(0);
    }

    public static synchronized List<String> extractLibraryWithDependenciesAbsolute(String packageName, NativeLibraryWithDependencies library) {
        try {
            String hash = NativeLibraryLoader.getHash(packageName, library);
            if (extractedLibraries.containsKey(hash)) {
                return extractedLibraries.get(hash);
            }
            String prefix = NativeLibraryLoader.createPackagePrefix(packageName);
            File packageDirectory = new File(LIBRARY_LOCATION, prefix);
            File directory = new File(packageDirectory, hash);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            ArrayList<String> libraryFiles = new ArrayList<String>();
            List<InputStream> inputStreams = NativeLibraryLoader.getInputstreams(packageName, library);
            libraryFiles.add(NativeLibraryLoader.extractFile(directory, library.getLibraryFilename(), inputStreams.get(0)));
            for (int i = 1; i < inputStreams.size(); ++i) {
                libraryFiles.add(NativeLibraryLoader.extractFile(directory, library.getDependencyFilenames()[i - 1], inputStreams.get(i)));
            }
            NativeLibraryLoader.closeInputStreams(inputStreams);
            extractedLibraries.put(hash, libraryFiles);
            return libraryFiles;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
    }

    public static synchronized boolean loadLibrary(NativeLibraryDescription libraryDescription) {
        NativeLibraryDescription.Platform platform;
        if (SystemUtils.IS_OS_WINDOWS && NativeLibraryLoader.isX86_32()) {
            platform = NativeLibraryDescription.Platform.WIN32;
        } else if (SystemUtils.IS_OS_WINDOWS && NativeLibraryLoader.isX86_64()) {
            platform = NativeLibraryDescription.Platform.WIN64;
        } else if (SystemUtils.IS_OS_MAC && NativeLibraryLoader.isX86_64()) {
            platform = NativeLibraryDescription.Platform.MACOSX64;
        } else if (SystemUtils.IS_OS_LINUX && NativeLibraryLoader.isX86_32()) {
            platform = NativeLibraryDescription.Platform.LINUX32;
        } else if (SystemUtils.IS_OS_LINUX && NativeLibraryLoader.isX86_64()) {
            platform = NativeLibraryDescription.Platform.LINUX64;
        } else {
            System.err.println("Cannot load library. Platform not supported");
            return false;
        }
        String packageName = libraryDescription.getPackage();
        NativeLibraryWithDependencies[] libraries = libraryDescription.getLibrariesWithDependencies(platform);
        if (libraries == null || libraries.length == 0) {
            return false;
        }
        try {
            for (NativeLibraryWithDependencies library : libraries) {
                NativeLibraryLoader.loadLibraryFromClassPath(platform, packageName, library);
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    private static synchronized void loadLibraryFromClassPath(NativeLibraryDescription.Platform platform, String packageName, NativeLibraryWithDependencies library) {
        String identifier = packageName + "+" + library.getLibraryFilename();
        if (!loadedLibraries.contains(identifier)) {
            List<String> libraries = NativeLibraryLoader.extractLibraryWithDependenciesAbsolute(packageName, library);
            if (platform == NativeLibraryDescription.Platform.WIN32 || platform == NativeLibraryDescription.Platform.WIN64) {
                for (int i = 1; i < libraries.size(); ++i) {
                    System.load(libraries.get(i));
                }
            }
            System.load(libraries.get(0));
            loadedLibraries.add(identifier);
        }
    }

    private static String createPackagePrefix(String packageName) {
        if ((packageName = packageName.trim().replace('.', '/')).length() > 0) {
            packageName = packageName + '/';
        }
        return packageName;
    }

    private static String extractFile(File target, String name, InputStream inputStream) throws IOException {
        File targetFile = new File(target, name);
        if (!targetFile.exists()) {
            Files.copy(inputStream, targetFile.toPath(), new CopyOption[0]);
        }
        return targetFile.getAbsolutePath();
    }

    private static void closeInputStreams(List<InputStream> inputStreams) {
        for (InputStream is : inputStreams) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static List<InputStream> getInputstreams(String packageName, NativeLibraryWithDependencies nativeLibrary) {
        String prefix = NativeLibraryLoader.createPackagePrefix(packageName);
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        InputStream libraryInputStream = NativeLibraryLoader.class.getClassLoader().getResourceAsStream(prefix + nativeLibrary.getLibraryFilename());
        if (libraryInputStream == null) {
            throw new UnsatisfiedLinkError("Cannot load library " + prefix + nativeLibrary.getLibraryFilename());
        }
        inputStreams.add(libraryInputStream);
        for (String dependency : nativeLibrary.getDependencyFilenames()) {
            InputStream dependencyLibrary = NativeLibraryLoader.class.getClassLoader().getResourceAsStream(prefix + dependency);
            if (dependencyLibrary == null) {
                throw new UnsatisfiedLinkError("Cannot load library " + prefix + dependency);
            }
            inputStreams.add(dependencyLibrary);
        }
        return inputStreams;
    }

    private static String getHash(String packageName, NativeLibraryWithDependencies nativeLibrary) throws IOException, NoSuchAlgorithmException {
        List<InputStream> inputStreams = NativeLibraryLoader.getInputstreams(packageName, nativeLibrary);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        for (InputStream is : inputStreams) {
            DigestInputStream digestStream = new DigestInputStream(is, messageDigest);
            byte[] buf = new byte[1024];
            while (digestStream.read(buf) > 0) {
            }
        }
        NativeLibraryLoader.closeInputStreams(inputStreams);
        return DatatypeConverter.printHexBinary((byte[])messageDigest.digest());
    }

    private static boolean isX86_32() {
        Processor processor = ArchUtils.getProcessor();
        return processor.isX86() && processor.is32Bit();
    }

    private static boolean isX86_64() {
        Processor processor = ArchUtils.getProcessor();
        return processor.isX86() && processor.is64Bit();
    }
}

